/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;

public class DoubleCountersTargetEffect
extends OneShotEffect {
    private final CounterType counterType;

    public DoubleCountersTargetEffect(CounterType counterType) {
        super(Outcome.Benefit);
        this.counterType = counterType;
        this.staticText = "double the number of " + counterType.getName() + " counters on it";
    }

    private DoubleCountersTargetEffect(DoubleCountersTargetEffect effect) {
        super(effect);
        this.counterType = effect.counterType;
    }

    @Override
    public DoubleCountersTargetEffect copy() {
        return new DoubleCountersTargetEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent == null) {
            return false;
        }
        return permanent.addCounters(this.counterType.createInstance(permanent.getCounters(game).getCount(this.counterType)), source.getControllerId(), source, game);
    }
}

