/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.StaticValue;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

public class DrawCardTargetEffect
extends OneShotEffect {
    protected DynamicValue amount;
    protected boolean optional;
    protected boolean upTo;

    public DrawCardTargetEffect(int amount) {
        this(StaticValue.get(amount));
    }

    public DrawCardTargetEffect(int amount, boolean optional) {
        this(StaticValue.get(amount), optional);
    }

    public DrawCardTargetEffect(DynamicValue amount) {
        this(amount, false);
    }

    public DrawCardTargetEffect(DynamicValue amount, boolean optional) {
        this(amount, optional, false);
    }

    public DrawCardTargetEffect(DynamicValue amount, boolean optional, boolean upto) {
        super(Outcome.DrawCard);
        this.amount = amount.copy();
        this.optional = optional;
        this.upTo = upto;
    }

    protected DrawCardTargetEffect(DrawCardTargetEffect effect) {
        super(effect);
        this.amount = effect.amount.copy();
        this.optional = effect.optional;
        this.upTo = effect.upTo;
    }

    @Override
    public DrawCardTargetEffect copy() {
        return new DrawCardTargetEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        for (UUID playerId : this.getTargetPointer().getTargets(game, source)) {
            Player player = game.getPlayer(playerId);
            if (player == null || !player.canRespond()) continue;
            int cardsToDraw = this.amount.calculate(game, source, this);
            if (this.upTo) {
                cardsToDraw = player.getAmount(0, cardsToDraw, "Draw how many cards?", source, game);
            }
            if (this.optional && !player.chooseUse(this.outcome, "Use draw effect?", source, game)) continue;
            player.drawCards(cardsToDraw, source, game);
        }
        return true;
    }

    @Override
    public String getText(Mode mode) {
        if (this.staticText != null && !this.staticText.isEmpty()) {
            return this.staticText;
        }
        StringBuilder sb = new StringBuilder(this.getTargetPointer().describeTargets(mode.getTargets(), "that player"));
        if (this.optional) {
            sb.append(" may draw ");
        } else {
            sb.append(" draws ");
        }
        if (this.upTo) {
            sb.append("up to ");
        }
        sb.append(CardUtil.numberToText(this.amount.toString(), "a")).append(" card");
        try {
            if (Integer.parseInt(this.amount.toString()) > 1) {
                sb.append('s');
            }
        }
        catch (Exception e) {
            sb.append('s');
        }
        String message = this.amount.getMessage();
        if (!message.isEmpty()) {
            sb.append(" for each ");
        }
        sb.append(message);
        return sb.toString();
    }
}

