/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

public class DrawCardsEqualToDifferenceEffect
extends OneShotEffect {
    private final int amount;

    public DrawCardsEqualToDifferenceEffect(int amount) {
        super(Outcome.Benefit);
        this.amount = amount;
        this.staticText = "draw cards equal to the difference";
    }

    private DrawCardsEqualToDifferenceEffect(DrawCardsEqualToDifferenceEffect effect) {
        super(effect);
        this.amount = effect.amount;
    }

    @Override
    public DrawCardsEqualToDifferenceEffect copy() {
        return new DrawCardsEqualToDifferenceEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        return player != null && player.drawCards(Math.max(this.amount - player.getHand().size(), 0), source, game) > 0;
    }
}

