/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

public class DrawDiscardControllerEffect
extends OneShotEffect {
    private final int cardsToDraw;
    private final int cardsToDiscard;
    private final boolean optional;

    public DrawDiscardControllerEffect() {
        this(1, 1);
    }

    public DrawDiscardControllerEffect(boolean optional) {
        this(1, 1, optional);
    }

    public DrawDiscardControllerEffect(int cardsToDraw, int cardsToDiscard) {
        this(cardsToDraw, cardsToDiscard, false);
    }

    public DrawDiscardControllerEffect(int cardsToDraw, int cardsToDiscard, boolean optional) {
        super(Outcome.DrawCard);
        this.cardsToDraw = cardsToDraw;
        this.cardsToDiscard = cardsToDiscard;
        this.optional = optional;
    }

    protected DrawDiscardControllerEffect(DrawDiscardControllerEffect effect) {
        super(effect);
        this.cardsToDraw = effect.cardsToDraw;
        this.cardsToDiscard = effect.cardsToDiscard;
        this.optional = effect.optional;
    }

    @Override
    public DrawDiscardControllerEffect copy() {
        return new DrawDiscardControllerEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        if (this.optional && !player.chooseUse(this.outcome, "Draw, then discard?", source, game)) {
            return true;
        }
        player.drawCards(this.cardsToDraw, source, game);
        player.discard(this.cardsToDiscard, false, false, source, game);
        return true;
    }

    @Override
    public String getText(Mode mode) {
        if (this.staticText != null && !this.staticText.isEmpty()) {
            return this.staticText;
        }
        return (this.optional ? "you may " : "") + "draw " + (this.cardsToDraw == 1 ? "a" : CardUtil.numberToText(this.cardsToDraw)) + " card" + (this.cardsToDraw == 1 ? "" : "s") + (this.optional ? ". If you do," : ", then") + " discard " + (this.cardsToDiscard == 1 ? "a" : CardUtil.numberToText(this.cardsToDiscard)) + " card" + (this.cardsToDiscard == 1 ? "" : "s");
    }
}

