/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import mage.abilities.Ability;
import mage.abilities.condition.common.FlippedCondition;
import mage.abilities.decorator.ConditionalContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CopyTokenEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.Token;
import mage.players.Player;

public class FlipSourceEffect
extends OneShotEffect {
    private final Token flipToken;

    public FlipSourceEffect(Token flipToken) {
        super(Outcome.BecomeCreature);
        this.flipToken = flipToken;
        this.staticText = "flip {this}";
    }

    protected FlipSourceEffect(FlipSourceEffect effect) {
        super(effect);
        this.flipToken = effect.flipToken;
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        Player controller = game.getPlayer(source.getControllerId());
        if (permanent != null && controller != null && permanent.flip(game)) {
            ConditionalContinuousEffect effect = new ConditionalContinuousEffect(new CopyTokenEffect(this.flipToken), FlippedCondition.instance, "");
            game.addEffect(effect, source);
            if (!game.isSimulation()) {
                game.informPlayers(controller.getLogName() + " flips " + permanent.getName());
            }
            return true;
        }
        return false;
    }

    @Override
    public FlipSourceEffect copy() {
        return new FlipSourceEffect(this);
    }
}

