/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

public class LivingDeathEffect
extends OneShotEffect {
    public LivingDeathEffect() {
        super(Outcome.Benefit);
        this.staticText = "Each player exiles all creature cards from their graveyard, then sacrifices all creatures they control, then puts all cards they exiled this way onto the battlefield";
    }

    protected LivingDeathEffect(LivingDeathEffect effect) {
        super(effect);
    }

    @Override
    public LivingDeathEffect copy() {
        return new LivingDeathEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = game.getObject(source);
        if (controller != null && sourceObject != null) {
            HashMap<UUID, Set<Card>> exiledCards = new HashMap<UUID, Set<Card>>();
            for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
                Set<Card> cardsPlayer;
                Player player = game.getPlayer(playerId);
                if (player == null || (cardsPlayer = player.getGraveyard().getCards(StaticFilters.FILTER_CARD_CREATURE, game)).isEmpty()) continue;
                exiledCards.put(player.getId(), cardsPlayer);
                player.moveCards(cardsPlayer, Zone.EXILED, source, game);
            }
            game.processAction();
            for (Permanent permanent : game.getBattlefield().getActivePermanents(StaticFilters.FILTER_PERMANENT_CREATURE, source.getControllerId(), game)) {
                permanent.sacrifice(source, game);
            }
            game.processAction();
            HashSet cardsToReturnFromExile = new HashSet();
            for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
                Set cardsPlayer;
                Player player = game.getPlayer(playerId);
                if (player == null || (cardsPlayer = (Set)exiledCards.get(playerId)) == null || cardsPlayer.isEmpty()) continue;
                cardsToReturnFromExile.addAll(cardsPlayer);
            }
            controller.moveCards(cardsToReturnFromExile, Zone.BATTLEFIELD, source, game, false, false, true, null);
            return true;
        }
        return false;
    }
}

