/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

public class LookLibraryTopCardTargetPlayerEffect
extends OneShotEffect {
    protected int amount;
    protected boolean putToGraveyard;
    protected boolean mayShuffleAfter;

    public LookLibraryTopCardTargetPlayerEffect(int amount) {
        super(Outcome.Benefit);
        this.amount = amount;
        this.putToGraveyard = false;
        this.mayShuffleAfter = false;
        this.setText();
    }

    public LookLibraryTopCardTargetPlayerEffect(int amount, boolean putToGraveyard) {
        super(Outcome.Benefit);
        this.amount = amount;
        this.putToGraveyard = putToGraveyard;
        this.mayShuffleAfter = false;
        this.setText();
    }

    public LookLibraryTopCardTargetPlayerEffect(int amount, boolean putToGraveyard, boolean mayShuffleAfter) {
        super(Outcome.Benefit);
        this.amount = amount;
        this.putToGraveyard = putToGraveyard;
        this.mayShuffleAfter = mayShuffleAfter;
        this.setText();
    }

    public LookLibraryTopCardTargetPlayerEffect() {
        this(1);
    }

    protected LookLibraryTopCardTargetPlayerEffect(LookLibraryTopCardTargetPlayerEffect effect) {
        super(effect);
        this.amount = effect.amount;
        this.putToGraveyard = effect.putToGraveyard;
        this.mayShuffleAfter = effect.mayShuffleAfter;
    }

    @Override
    public LookLibraryTopCardTargetPlayerEffect copy() {
        return new LookLibraryTopCardTargetPlayerEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Player targetPlayer = game.getPlayer(source.getFirstTarget());
        MageObject sourceObject = game.getObject(source);
        if (player != null && targetPlayer != null && sourceObject != null) {
            CardsImpl cards = new CardsImpl();
            cards.addAllCards(targetPlayer.getLibrary().getTopCards(game, this.amount));
            player.lookAtCards(sourceObject.getIdName(), cards, game);
            if (this.putToGraveyard) {
                for (Card card : cards.getCards(game)) {
                    if (player.chooseUse(this.outcome, "Put that card into its owner's graveyard?", source, game)) {
                        player.moveCardToGraveyardWithInfo(card, source, game, Zone.LIBRARY);
                        continue;
                    }
                    game.informPlayers(player.getLogName() + " puts the card back on top of the library.");
                }
            }
            if (this.mayShuffleAfter && player.chooseUse(Outcome.Benefit, player == targetPlayer ? "Shuffle your library?" : "Have the chosen player shuffle?", source, game)) {
                targetPlayer.shuffleLibrary(source, game);
            }
            return true;
        }
        return false;
    }

    private void setText() {
        StringBuilder sb = new StringBuilder("look at the top ");
        if (this.amount > 1) {
            sb.append(CardUtil.numberToText(this.amount));
            sb.append(" cards ");
        } else {
            sb.append("card ");
        }
        sb.append("of target player's library");
        if (this.putToGraveyard) {
            sb.append(". You may put ");
            if (this.amount > 1) {
                sb.append("those cards");
            } else {
                sb.append("that card");
            }
            sb.append(" into that player's graveyard");
        }
        if (this.mayShuffleAfter) {
            sb.append(". You may then have that player shuffle that library");
        }
        this.staticText = sb.toString();
    }
}

