/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;

public class PhaseOutTargetEffect
extends OneShotEffect {
    public PhaseOutTargetEffect() {
        super(Outcome.Detriment);
    }

    private PhaseOutTargetEffect(PhaseOutTargetEffect effect) {
        super(effect);
    }

    @Override
    public PhaseOutTargetEffect copy() {
        return new PhaseOutTargetEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        for (UUID targetId : this.getTargetPointer().getTargets(game, source)) {
            Permanent permanent = game.getPermanent(targetId);
            if (permanent == null) continue;
            permanent.phaseOut(game);
        }
        return true;
    }

    @Override
    public String getText(Mode mode) {
        if (this.staticText != null && !this.staticText.isEmpty()) {
            return this.staticText;
        }
        return this.getTargetPointer().describeTargets(mode.getTargets(), "it") + (this.getTargetPointer().isPlural(mode.getTargets()) ? " phase out" : " phases out");
    }
}

