/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import java.util.ArrayList;
import java.util.List;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenCopyTargetEffect;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.permanent.TokenPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.TargetPermanent;
import mage.target.targetpointer.FixedTarget;

public class PopulateEffect
extends OneShotEffect {
    private final boolean tappedAndAttacking;
    private static final FilterPermanent filter = new FilterCreaturePermanent("creature token for populate");
    private final List<Permanent> addedTokenPermanents = new ArrayList<Permanent>();

    public PopulateEffect() {
        this("");
    }

    public PopulateEffect(String prefixText) {
        this(false);
        this.staticText = (!prefixText.isEmpty() ? ", " + prefixText + " " : "") + "populate. <i>(Create a token that's a copy of a creature token you control.)</i>";
    }

    public PopulateEffect(boolean tappedAndAttacking) {
        super(Outcome.Copy);
        this.tappedAndAttacking = tappedAndAttacking;
        this.staticText = "populate. The token enters the battlefield tapped and attacking. <i>(To populate, create a token that's a copy of a creature token you control.)</i>";
    }

    protected PopulateEffect(PopulateEffect effect) {
        super(effect);
        this.tappedAndAttacking = effect.tappedAndAttacking;
        this.addedTokenPermanents.addAll(effect.addedTokenPermanents);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetPermanent target = new TargetPermanent(filter);
        target.withNotTarget(true);
        if (!target.canChoose(source.getControllerId(), source, game)) {
            return true;
        }
        player.choose(Outcome.Copy, target, source, game);
        Permanent tokenToCopy = game.getPermanent(target.getFirstTarget());
        if (tokenToCopy == null) {
            return true;
        }
        game.informPlayers("Token selected for populate: " + tokenToCopy.getLogName());
        CreateTokenCopyTargetEffect effect = new CreateTokenCopyTargetEffect(null, null, false, 1, this.tappedAndAttacking, this.tappedAndAttacking);
        effect.setTargetPointer(new FixedTarget(target.getFirstTarget(), game));
        effect.apply(game, source);
        this.addedTokenPermanents.clear();
        this.addedTokenPermanents.addAll(effect.getAddedPermanents());
        return true;
    }

    public List<Permanent> getAddedPermanents() {
        return this.addedTokenPermanents;
    }

    @Override
    public PopulateEffect copy() {
        return new PopulateEffect(this);
    }

    static {
        filter.add(TokenPredicate.TRUE);
        filter.add(TargetController.YOU.getControllerPredicate());
    }
}

