/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import mage.abilities.Ability;
import mage.abilities.effects.PreventionEffectImpl;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;

public class PreventAllDamageToPlayersEffect
extends PreventionEffectImpl {
    public PreventAllDamageToPlayersEffect(Duration duration, boolean onlyCombat) {
        super(duration, Integer.MAX_VALUE, onlyCombat);
        this.staticText = this.setText();
    }

    protected PreventAllDamageToPlayersEffect(PreventAllDamageToPlayersEffect effect) {
        super(effect);
    }

    @Override
    public PreventAllDamageToPlayersEffect copy() {
        return new PreventAllDamageToPlayersEffect(this);
    }

    @Override
    public boolean applies(GameEvent event, Ability source, Game game) {
        Player controller;
        return super.applies(event, source, game) && event.getType() == GameEvent.EventType.DAMAGE_PLAYER && (controller = game.getPlayer(source.getControllerId())) != null && game.getState().getPlayersInRange(controller.getId(), game).contains(event.getTargetId());
    }

    private String setText() {
        StringBuilder sb = new StringBuilder("Prevent all ");
        if (this.onlyCombat) {
            sb.append("combat ");
        }
        sb.append("damage that would be dealt to players");
        if (this.duration == Duration.EndOfTurn) {
            sb.append(" this turn");
        }
        return sb.toString();
    }
}

