/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import mage.abilities.Ability;
import mage.abilities.effects.common.PreventAllDamageByAllPermanentsEffect;
import mage.constants.Duration;
import mage.filter.FilterPermanent;
import mage.game.Game;
import mage.game.events.GameEvent;

public class PreventAllDamageToSourceByPermanentsEffect
extends PreventAllDamageByAllPermanentsEffect {
    public PreventAllDamageToSourceByPermanentsEffect(FilterPermanent filter) {
        this(filter, false);
    }

    public PreventAllDamageToSourceByPermanentsEffect(FilterPermanent filter, boolean onlyCombat) {
        this(filter, Duration.WhileOnBattlefield, onlyCombat);
    }

    public PreventAllDamageToSourceByPermanentsEffect(FilterPermanent filter, Duration duration, boolean onlyCombat) {
        super(filter, duration, onlyCombat);
        this.setText();
    }

    protected PreventAllDamageToSourceByPermanentsEffect(PreventAllDamageToSourceByPermanentsEffect effect) {
        super(effect);
    }

    @Override
    public PreventAllDamageToSourceByPermanentsEffect copy() {
        return new PreventAllDamageToSourceByPermanentsEffect(this);
    }

    @Override
    public boolean applies(GameEvent event, Ability source, Game game) {
        return super.applies(event, source, game) && event.getTargetId().equals(source.getSourceId());
    }

    private void setText() {
        StringBuilder sb = new StringBuilder("prevent all ");
        if (this.onlyCombat) {
            sb.append("combat ");
        }
        sb.append("damage that would be dealt to {this} ");
        if (this.duration == Duration.EndOfTurn) {
            sb.append("this turn ");
        }
        sb.append("by ");
        sb.append(this.filter.getMessage());
        this.staticText = sb.toString();
    }
}

