/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.PreventionEffectImpl;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.GameEvent;

public class PreventDamageToSourceEffect
extends PreventionEffectImpl {
    public PreventDamageToSourceEffect(Duration duration, int amountToPrevent) {
        super(duration, amountToPrevent, false);
    }

    protected PreventDamageToSourceEffect(PreventDamageToSourceEffect effect) {
        super(effect);
    }

    @Override
    public PreventDamageToSourceEffect copy() {
        return new PreventDamageToSourceEffect(this);
    }

    @Override
    public void init(Ability source, Game game) {
        super.init(source, game);
        if (this.duration.isOnlyValidIfNoZoneChange() && source.getSourcePermanentIfItStillExists(game) == null) {
            this.discard();
        }
    }

    @Override
    public boolean applies(GameEvent event, Ability source, Game game) {
        if (source.getSourcePermanentIfItStillExists(game) == null) {
            return false;
        }
        return super.applies(event, source, game) && event.getTargetId().equals(source.getSourceId());
    }

    @Override
    public String getText(Mode mode) {
        if (this.staticText != null && !this.staticText.isEmpty()) {
            return this.staticText;
        }
        StringBuilder sb = new StringBuilder();
        if (this.amountToPrevent == Integer.MAX_VALUE) {
            sb.append("Prevent all damage that would be dealt to ");
        } else {
            sb.append("Prevent the next ").append(this.amountToPrevent).append(" damage that would be dealt to ");
        }
        sb.append("{this} ");
        if (this.duration == Duration.EndOfTurn) {
            sb.append("this turn");
        } else {
            sb.append(this.duration.toString());
        }
        return sb.toString();
    }
}

