/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.util.CardUtil;

public class PutCardFromHandOrGraveyardOntoBattlefieldEffect
extends OneShotEffect {
    private final FilterCard filter;
    private final boolean tapped;

    public PutCardFromHandOrGraveyardOntoBattlefieldEffect(FilterCard filter, boolean tapped) {
        super(Outcome.PutCardInPlay);
        this.filter = filter;
        this.tapped = tapped;
        this.staticText = "you may put " + CardUtil.addArticle(filter.getMessage()) + " from your hand or graveyard onto the battlefield" + (tapped ? " tapped" : "");
    }

    private PutCardFromHandOrGraveyardOntoBattlefieldEffect(PutCardFromHandOrGraveyardOntoBattlefieldEffect effect) {
        super(effect);
        this.filter = effect.filter;
        this.tapped = effect.tapped;
    }

    @Override
    public PutCardFromHandOrGraveyardOntoBattlefieldEffect copy() {
        return new PutCardFromHandOrGraveyardOntoBattlefieldEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl();
        cards.addAllCards(controller.getHand().getCards(this.filter, source.getControllerId(), source, game));
        cards.addAllCards(controller.getGraveyard().getCards(this.filter, source.getControllerId(), source, game));
        if (cards.isEmpty()) {
            return true;
        }
        TargetCard target = new TargetCard(0, 1, Zone.ALL, this.filter);
        target.withNotTarget(true);
        controller.choose(this.outcome, cards, target, source, game);
        Card card = game.getCard(target.getFirstTarget());
        if (card != null) {
            controller.moveCards(card, Zone.BATTLEFIELD, source, game, this.tapped, false, false, null);
        }
        return true;
    }
}

