/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.Counter;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;

public class PutSourceCountersOnTargetEffect
extends OneShotEffect {
    private final CounterType counterType;

    public PutSourceCountersOnTargetEffect() {
        this((CounterType)null);
    }

    public PutSourceCountersOnTargetEffect(CounterType counterType) {
        super(Outcome.Benefit);
        this.counterType = counterType;
    }

    private PutSourceCountersOnTargetEffect(PutSourceCountersOnTargetEffect effect) {
        super(effect);
        this.counterType = effect.counterType;
    }

    @Override
    public PutSourceCountersOnTargetEffect copy() {
        return new PutSourceCountersOnTargetEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Permanent sourcePermanent = source.getSourcePermanentOrLKI(game);
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (sourcePermanent == null || permanent == null) {
            return false;
        }
        if (this.counterType != null) {
            int count = sourcePermanent.getCounters(game).getCount(this.counterType);
            return count > 0 && permanent.addCounters(this.counterType.createInstance(count), source, game);
        }
        sourcePermanent.getCounters(game).values().stream().forEach(counter -> permanent.addCounters((Counter)counter, source.getControllerId(), source, game));
        return true;
    }

    @Override
    public String getText(Mode mode) {
        if (this.staticText != null && !this.staticText.isEmpty()) {
            return this.staticText;
        }
        return "put its" + (this.counterType != null ? " " + (Object)((Object)this.counterType) : "") + " counters on " + this.getTargetPointer().describeTargets(mode.getTargets(), "that creature");
    }
}

