/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;

public class RecruiterEffect
extends OneShotEffect {
    private final FilterCard filter;

    public RecruiterEffect(FilterCard filter) {
        super(Outcome.Benefit);
        this.filter = filter;
    }

    protected RecruiterEffect(RecruiterEffect effect) {
        super(effect);
        this.filter = effect.filter.copy();
    }

    @Override
    public RecruiterEffect copy() {
        return new RecruiterEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            TargetCardInLibrary targetCards = new TargetCardInLibrary(0, Integer.MAX_VALUE, this.filter);
            CardsImpl cards = new CardsImpl();
            if (controller.searchLibrary(targetCards, source, game)) {
                cards.addAll(targetCards.getTargets());
            }
            controller.revealCards(this.staticText, (Cards)cards, game);
            controller.shuffleLibrary(source, game);
            if (!cards.isEmpty()) {
                controller.putCardsOnTopOfLibrary(cards, game, source, true);
            }
            return true;
        }
        return false;
    }

    @Override
    public String getText(Mode mode) {
        if (this.staticText != null && !this.staticText.isEmpty()) {
            return this.staticText;
        }
        return "search your library for any number of " + this.filter.getMessage() + ", reveal them, then shuffle and put those cards on top in any order";
    }
}

