/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.ExileZone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

public class ReturnFromExileForSourceEffect
extends OneShotEffect {
    private final Zone returnToZone;
    private boolean pluralCards;
    private boolean pluralOwners;
    private boolean putPhrasing;

    public ReturnFromExileForSourceEffect(Zone zone) {
        super(Outcome.PutCardInPlay);
        this.returnToZone = zone;
        this.pluralCards = false;
        this.pluralOwners = false;
        this.putPhrasing = false;
        this.updateText();
    }

    protected ReturnFromExileForSourceEffect(ReturnFromExileForSourceEffect effect) {
        super(effect);
        this.returnToZone = effect.returnToZone;
        this.pluralCards = effect.pluralCards;
        this.pluralOwners = effect.pluralOwners;
        this.putPhrasing = effect.putPhrasing;
    }

    @Override
    public ReturnFromExileForSourceEffect copy() {
        return new ReturnFromExileForSourceEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        Permanent permanentLeftBattlefield = (Permanent)this.getValue("permanentLeftBattlefield");
        UUID exileId = permanentLeftBattlefield != null ? CardUtil.getExileZoneId(game, source.getSourceId(), permanentLeftBattlefield.getZoneChangeCounter(game)) : CardUtil.getExileZoneId(game, source.getSourceId(), source.getStackMomentSourceZCC());
        ExileZone exile = game.getExile().getExileZone(exileId);
        if (exile != null) {
            if (Zone.BATTLEFIELD.equals((Object)this.returnToZone)) {
                controller.moveCards(exile.getCards(game), this.returnToZone, source, game, false, false, true, null);
            } else {
                controller.moveCards(exile, this.returnToZone, source, game);
            }
        }
        return true;
    }

    public ReturnFromExileForSourceEffect withText(boolean pluralCards, boolean pluralOwners, boolean putPhrasing) {
        this.pluralCards = pluralCards;
        this.pluralOwners = pluralOwners;
        this.putPhrasing = putPhrasing;
        this.updateText();
        return this;
    }

    private void updateText() {
        StringBuilder sb = new StringBuilder();
        if (this.putPhrasing) {
            sb.append("put ").append(this.pluralCards ? "all cards " : "the card ").append("exiled with {this} ");
            sb.append(this.returnToZone == Zone.BATTLEFIELD ? "onto " : "into ");
        } else {
            sb.append("return the exiled ").append(this.pluralCards ? "cards" : "card").append(" to ");
        }
        if (this.returnToZone == Zone.BATTLEFIELD) {
            sb.append("the battlefield under ");
        }
        sb.append(this.pluralCards ? "their " : "its ").append(this.pluralOwners ? "owners' " : "owner's ");
        switch (this.returnToZone) {
            case BATTLEFIELD: {
                sb.append("control");
                break;
            }
            case HAND: {
                sb.append(this.pluralOwners ? "hands" : "hand");
                break;
            }
            case GRAVEYARD: {
                sb.append(this.pluralOwners ? "graveyards" : "graveyard");
            }
        }
        this.staticText = sb.toString();
    }
}

