/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import java.util.Collection;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInYourGraveyard;
import mage.util.CardUtil;

public class ReturnFromGraveyardAtRandomEffect
extends OneShotEffect {
    private final FilterCard filter;
    private final Zone zone;
    private final int number;

    public ReturnFromGraveyardAtRandomEffect(FilterCard filter, Zone zone) {
        this(filter, zone, 1);
    }

    public ReturnFromGraveyardAtRandomEffect(FilterCard filter, Zone zone, int number) {
        super(Outcome.ReturnToHand);
        this.filter = filter;
        this.zone = zone;
        this.number = number;
        this.staticText = "return " + (number == 1 ? CardUtil.addArticle(filter.getMessage()) : CardUtil.numberToText(number) + " " + filter.getMessage()) + " at random from your graveyard to " + (zone == Zone.HAND ? "your hand" : "the battlefield");
    }

    protected ReturnFromGraveyardAtRandomEffect(ReturnFromGraveyardAtRandomEffect effect) {
        super(effect);
        this.filter = effect.filter;
        this.zone = effect.zone;
        this.number = effect.number;
    }

    @Override
    public ReturnFromGraveyardAtRandomEffect copy() {
        return new ReturnFromGraveyardAtRandomEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null || player.getGraveyard().isEmpty()) {
            return false;
        }
        TargetCardInYourGraveyard target = new TargetCardInYourGraveyard(Math.min(player.getGraveyard().size(), this.number), this.filter);
        target.withNotTarget(true);
        target.setRandom(true);
        target.chooseTarget(this.outcome, player.getId(), source, game);
        return player.moveCards(new CardsImpl((Collection<UUID>)target.getTargets()), this.zone, source, game);
    }
}

