/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import java.util.Collection;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.OneShotEffect;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

public class ReturnFromGraveyardToHandTargetEffect
extends OneShotEffect {
    public ReturnFromGraveyardToHandTargetEffect() {
        super(Outcome.ReturnToHand);
    }

    protected ReturnFromGraveyardToHandTargetEffect(ReturnFromGraveyardToHandTargetEffect effect) {
        super(effect);
    }

    @Override
    public ReturnFromGraveyardToHandTargetEffect copy() {
        return new ReturnFromGraveyardToHandTargetEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl((Collection<UUID>)this.getTargetPointer().getTargets(game, source));
        cards.retainZone(Zone.GRAVEYARD, game);
        return !cards.isEmpty() && controller.moveCards(cards, Zone.HAND, source, game);
    }

    @Override
    public String getText(Mode mode) {
        if (this.staticText != null && !this.staticText.isEmpty()) {
            return this.staticText;
        }
        String targetDescription = this.getTargetPointer().describeTargets(mode.getTargets(), "");
        return "return " + targetDescription + (targetDescription.contains("graveyard") ? " to your hand" : " from your graveyard to your hand");
    }
}

