/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.stack.Spell;
import mage.players.Player;

public class ReturnToHandSourceEffect
extends OneShotEffect {
    boolean fromBattlefieldOnly;
    boolean returnFromNextZone;

    public ReturnToHandSourceEffect() {
        this(false);
    }

    public ReturnToHandSourceEffect(boolean fromBattlefieldOnly) {
        this(fromBattlefieldOnly, false);
    }

    public ReturnToHandSourceEffect(boolean fromBattlefieldOnly, boolean returnFromNextZone) {
        super(Outcome.ReturnToHand);
        this.fromBattlefieldOnly = fromBattlefieldOnly;
        this.returnFromNextZone = returnFromNextZone;
        this.staticText = "return {this} to its owner's hand";
    }

    protected ReturnToHandSourceEffect(ReturnToHandSourceEffect effect) {
        super(effect);
        this.fromBattlefieldOnly = effect.fromBattlefieldOnly;
        this.returnFromNextZone = effect.returnFromNextZone;
    }

    @Override
    public ReturnToHandSourceEffect copy() {
        return new ReturnToHandSourceEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        MageObject mageObject = this.returnFromNextZone && game.getState().getZoneChangeCounter(source.getSourceId()) == source.getStackMomentSourceZCC() + 1 ? game.getObject(source) : source.getSourceObjectIfItStillExists(game);
        if (mageObject == null) {
            return true;
        }
        switch (game.getState().getZone(mageObject.getId())) {
            case BATTLEFIELD: {
                Permanent permanent = game.getPermanent(source.getSourceId());
                if (permanent == null || !permanent.isPhasedIn()) break;
                return controller.moveCards(permanent, Zone.HAND, source, game);
            }
            case GRAVEYARD: 
            case EXILED: {
                Card card = (Card)mageObject;
                return !this.fromBattlefieldOnly && controller.moveCards(card, Zone.HAND, source, game);
            }
            case STACK: {
                Spell spell = game.getSpell(source.getSourceId());
                return !this.fromBattlefieldOnly && spell != null && controller.moveCards(spell.getMainCard(), Zone.HAND, source, game);
            }
        }
        return true;
    }
}

