/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import java.util.List;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

public class TapAllTargetPlayerControlsEffect
extends OneShotEffect {
    private final FilterPermanent filter;

    public TapAllTargetPlayerControlsEffect(FilterPermanent filter) {
        super(Outcome.Tap);
        this.filter = filter;
    }

    protected TapAllTargetPlayerControlsEffect(TapAllTargetPlayerControlsEffect effect) {
        super(effect);
        this.filter = effect.filter.copy();
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (player != null) {
            List<Permanent> permanents = game.getBattlefield().getAllActivePermanents(this.filter, player.getId(), game);
            for (Permanent p : permanents) {
                p.tap(source, game);
            }
            return true;
        }
        return false;
    }

    @Override
    public TapAllTargetPlayerControlsEffect copy() {
        return new TapAllTargetPlayerControlsEffect(this);
    }

    @Override
    public String getText(Mode mode) {
        if (this.staticText != null && !this.staticText.isEmpty()) {
            return this.staticText;
        }
        return "tap all " + this.filter.getMessage() + ' ' + this.getTargetPointer().describeTargets(mode.getTargets(), "that player") + " controls";
    }
}

