/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;

public class TapEnchantedEffect
extends OneShotEffect {
    public TapEnchantedEffect() {
        this("creature");
    }

    public TapEnchantedEffect(String name) {
        super(Outcome.Tap);
        this.staticText = "tap enchanted " + name;
    }

    protected TapEnchantedEffect(TapEnchantedEffect effect) {
        super(effect);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Permanent attach;
        Permanent permanent = source.getSourcePermanentOrLKI(game);
        if (permanent != null && (attach = game.getPermanent(permanent.getAttachedTo())) != null) {
            attach.tap(source, game);
            return true;
        }
        return false;
    }

    @Override
    public TapEnchantedEffect copy() {
        return new TapEnchantedEffect(this);
    }
}

