/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;

public class TapTargetEffect
extends OneShotEffect {
    public TapTargetEffect() {
        this((String)null);
    }

    public TapTargetEffect(String text) {
        super(Outcome.Tap);
        if (text != null) {
            this.staticText = text;
        }
    }

    protected TapTargetEffect(TapTargetEffect effect) {
        super(effect);
    }

    @Override
    public TapTargetEffect copy() {
        return new TapTargetEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        for (UUID target : this.getTargetPointer().getTargets(game, source)) {
            Permanent permanent = game.getPermanent(target);
            if (permanent == null) continue;
            permanent.tap(source, game);
        }
        return true;
    }

    @Override
    public String getText(Mode mode) {
        if (this.staticText != null && !this.staticText.isEmpty()) {
            return this.staticText;
        }
        return "tap " + this.getTargetPointer().describeTargets(mode.getTargets(), "that creature");
    }
}

