/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import java.util.Collection;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.OneShotEffect;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.util.CardUtil;

public class TargetPlayerShufflesTargetCardsEffect
extends OneShotEffect {
    private final int targetPlayerIndex;

    public TargetPlayerShufflesTargetCardsEffect() {
        this(0);
    }

    public TargetPlayerShufflesTargetCardsEffect(int targetPlayerIndex) {
        super(Outcome.Neutral);
        this.targetPlayerIndex = targetPlayerIndex;
    }

    private TargetPlayerShufflesTargetCardsEffect(TargetPlayerShufflesTargetCardsEffect effect) {
        super(effect);
        this.targetPlayerIndex = effect.targetPlayerIndex;
    }

    @Override
    public TargetPlayerShufflesTargetCardsEffect copy() {
        return new TargetPlayerShufflesTargetCardsEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player targetPlayer = game.getPlayer(((Target)source.getTargets().get(this.targetPlayerIndex)).getFirstTarget());
        CardsImpl cards = new CardsImpl((Collection<UUID>)((Target)source.getTargets().get(this.targetPlayerIndex + 1)).getTargets());
        if (targetPlayer != null && !cards.isEmpty()) {
            return targetPlayer.shuffleCardsToLibrary(cards, game, source);
        }
        return false;
    }

    @Override
    public String getText(Mode mode) {
        if (this.staticText != null && !this.staticText.isEmpty()) {
            return this.staticText;
        }
        String rule = "target player shuffles ";
        int targetNumber = ((Target)mode.getTargets().get(this.targetPlayerIndex + 1)).getMaxNumberOfTargets();
        rule = targetNumber == Integer.MAX_VALUE ? rule + "any number of target cards" : rule + "up to " + CardUtil.numberToText(targetNumber, "one") + " target card" + (targetNumber > 1 ? "s" : "");
        return rule + " from their graveyard into their library";
    }
}

