/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import java.util.ArrayList;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.Target;

public class TargetsDamageTargetsEffect
extends OneShotEffect {
    private final boolean describeDamagingTargets;

    public TargetsDamageTargetsEffect(boolean describeDamagingTargets) {
        super(Outcome.Benefit);
        this.describeDamagingTargets = describeDamagingTargets;
    }

    private TargetsDamageTargetsEffect(TargetsDamageTargetsEffect effect) {
        super(effect);
        this.describeDamagingTargets = effect.describeDamagingTargets;
    }

    @Override
    public TargetsDamageTargetsEffect copy() {
        return new TargetsDamageTargetsEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Permanent permanent;
        if (source.getTargets().size() < 2) {
            return false;
        }
        Target damageTarget = source.getTargets().getByTag(1);
        Target additionalDamageTarget = source.getTargets().getByTag(2);
        Target destTarget = source.getTargets().getByTag(3);
        ArrayList<Permanent> damagingPermanents = new ArrayList<Permanent>();
        ArrayList<Permanent> receivingPermanents = new ArrayList<Permanent>();
        for (UUID id : damageTarget.getTargets()) {
            permanent = game.getPermanent(id);
            if (permanent == null) continue;
            damagingPermanents.add(permanent);
        }
        if (additionalDamageTarget != null) {
            for (UUID id : additionalDamageTarget.getTargets()) {
                permanent = game.getPermanent(id);
                if (permanent == null) continue;
                damagingPermanents.add(permanent);
            }
        }
        for (UUID id : destTarget.getTargets()) {
            permanent = game.getPermanent(id);
            if (permanent == null) continue;
            receivingPermanents.add(permanent);
        }
        if (receivingPermanents.isEmpty() || damagingPermanents.isEmpty()) {
            return false;
        }
        for (Permanent receivingPermanent : receivingPermanents) {
            for (Permanent damagingPermanent : damagingPermanents) {
                receivingPermanent.damage(damagingPermanent.getPower().getValue(), damagingPermanent.getId(), source, game, false, true);
            }
        }
        return true;
    }

    @Override
    public String getText(Mode mode) {
        if (this.staticText != null && !this.staticText.isEmpty()) {
            return this.staticText;
        }
        StringBuilder sb = new StringBuilder();
        if (this.describeDamagingTargets) {
            sb.append(mode.getTargets().getByTag(1).getDescription());
            if (mode.getTargets().getByTag(2) != null) {
                sb.append(" and ").append(mode.getTargets().getByTag(2).getDescription());
            }
        } else {
            sb.append("they");
        }
        sb.append(" each deal damage equal to their power to ");
        sb.append(mode.getTargets().getByTag(3).getDescription());
        return sb.toString();
    }
}

