/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.asthought;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;

public class MayLookAtTargetCardEffect
extends AsThoughEffectImpl {
    private final UUID authorizedPlayerId;

    public MayLookAtTargetCardEffect(UUID authorizedPlayerId) {
        super(AsThoughEffectType.LOOK_AT_FACE_DOWN, Duration.EndOfGame, Outcome.Benefit);
        this.authorizedPlayerId = authorizedPlayerId;
        this.staticText = "You may look at the cards exiled with {this}";
    }

    private MayLookAtTargetCardEffect(MayLookAtTargetCardEffect effect) {
        super(effect);
        this.authorizedPlayerId = effect.authorizedPlayerId;
    }

    @Override
    public boolean apply(Game game, Ability source) {
        return true;
    }

    @Override
    public MayLookAtTargetCardEffect copy() {
        return new MayLookAtTargetCardEffect(this);
    }

    @Override
    public boolean applies(UUID objectId, Ability source, UUID affectedControllerId, Game game) {
        UUID cardId = this.getTargetPointer().getFirst(game, source);
        if (cardId == null) {
            this.discard();
        }
        return affectedControllerId.equals(this.authorizedPlayerId) && objectId.equals(cardId);
    }
}

