/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.asthought;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.PlayLandAbility;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.abilities.effects.common.asthought.YouMaySpendManaAsAnyColorToCastTargetEffect;
import mage.cards.Card;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.FixedTargets;
import mage.util.CardUtil;

public class PlayFromNotOwnHandZoneTargetEffect
extends AsThoughEffectImpl {
    private final Zone fromZone;
    private final TargetController allowedCaster;
    private final boolean withoutMana;
    private final boolean onlyCastAllowed;

    public PlayFromNotOwnHandZoneTargetEffect() {
        this(Duration.EndOfTurn);
    }

    public PlayFromNotOwnHandZoneTargetEffect(Duration duration) {
        this(Zone.ALL, TargetController.YOU, duration);
    }

    public PlayFromNotOwnHandZoneTargetEffect(Zone fromZone, Duration duration) {
        this(fromZone, TargetController.YOU, duration);
    }

    public PlayFromNotOwnHandZoneTargetEffect(Zone fromZone, TargetController allowedCaster, Duration duration) {
        this(fromZone, allowedCaster, duration, false);
    }

    public PlayFromNotOwnHandZoneTargetEffect(Zone fromZone, TargetController allowedCaster, Duration duration, boolean withoutMana) {
        this(fromZone, allowedCaster, duration, withoutMana, false);
    }

    public PlayFromNotOwnHandZoneTargetEffect(Zone fromZone, TargetController allowedCaster, Duration duration, boolean withoutMana, boolean onlyCastAllowed) {
        super(AsThoughEffectType.PLAY_FROM_NOT_OWN_HAND_ZONE, duration, withoutMana ? Outcome.PlayForFree : Outcome.PutCardInPlay);
        this.fromZone = fromZone;
        this.allowedCaster = allowedCaster;
        this.withoutMana = withoutMana;
        this.onlyCastAllowed = onlyCastAllowed;
    }

    protected PlayFromNotOwnHandZoneTargetEffect(PlayFromNotOwnHandZoneTargetEffect effect) {
        super(effect);
        this.fromZone = effect.fromZone;
        this.allowedCaster = effect.allowedCaster;
        this.withoutMana = effect.withoutMana;
        this.onlyCastAllowed = effect.onlyCastAllowed;
    }

    @Override
    public boolean apply(Game game, Ability source) {
        return true;
    }

    @Override
    public PlayFromNotOwnHandZoneTargetEffect copy() {
        return new PlayFromNotOwnHandZoneTargetEffect(this);
    }

    @Override
    public boolean applies(UUID objectId, Ability source, UUID affectedControllerId, Game game) {
        return this.applies(objectId, null, source, game, affectedControllerId);
    }

    @Override
    public boolean applies(UUID objectId, Ability affectedAbility, Ability source, Game game, UUID playerId) {
        if (affectedAbility == null) {
            throw new IllegalArgumentException("Wrong code usage: can't call applies method on empty affectedAbility");
        }
        List<UUID> targets = this.getTargetPointer().getTargets(game, source);
        if (targets.isEmpty()) {
            this.discard();
            return false;
        }
        if (!game.getState().getZone(objectId).match(this.fromZone)) {
            return false;
        }
        switch (this.allowedCaster) {
            case YOU: {
                if (playerId == source.getControllerId()) break;
                return false;
            }
            case OPPONENT: {
                if (game.getOpponents(source.getControllerId()).contains(playerId)) break;
                return false;
            }
            case OWNER: {
                if (playerId == game.getCard(objectId).getOwnerId()) break;
                return false;
            }
        }
        UUID objectIdToCast = CardUtil.getMainCardId(game, objectId);
        if (!targets.contains(objectIdToCast)) {
            return false;
        }
        if (!affectedAbility.getAbilityType().isPlayCardAbility() || this.onlyCastAllowed && affectedAbility instanceof PlayLandAbility) {
            return false;
        }
        if (this.withoutMana) {
            this.allowCardToPlayWithoutMana(objectId, source, playerId, game);
        }
        return true;
    }

    public static boolean exileAndPlayFromExile(Game game, Ability source, Card card, TargetController allowedCaster, Duration duration, boolean withoutMana, boolean anyColor, boolean onlyCastAllowed) {
        if (card == null) {
            return true;
        }
        HashSet<Card> cards = new HashSet<Card>();
        cards.add(card);
        return PlayFromNotOwnHandZoneTargetEffect.exileAndPlayFromExile(game, source, cards, allowedCaster, duration, withoutMana, anyColor, onlyCastAllowed);
    }

    public static boolean exileAndPlayFromExile(Game game, Ability source, Set<Card> cards, TargetController allowedCaster, Duration duration, boolean withoutMana, boolean anyColor, boolean onlyCastAllowed) {
        if (cards == null || cards.isEmpty()) {
            return true;
        }
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = source.getSourceObject(game);
        if (controller == null || sourceObject == null) {
            return false;
        }
        UUID exileId = CardUtil.getExileZoneId(controller.getId().toString() + "-" + game.getState().getTurnNum() + "-" + sourceObject.getIdName(), game);
        String exileName = sourceObject.getIdName() + " free play" + (Duration.EndOfTurn.equals((Object)duration) ? " on turn " + game.getState().getTurnNum() : "") + " for " + controller.getName();
        if (Duration.EndOfTurn.equals((Object)duration)) {
            game.getExile().createZone(exileId, exileName).setCleanupOnEndTurn(true);
        }
        if (!controller.moveCardsToExile(cards, source, game, true, exileId, exileName)) {
            return false;
        }
        Set cardsToPlay = cards.stream().map(Card::getMainCard).filter(card -> Zone.EXILED.equals((Object)game.getState().getZone(card.getId()))).collect(Collectors.toSet());
        PlayFromNotOwnHandZoneTargetEffect effect = new PlayFromNotOwnHandZoneTargetEffect(Zone.EXILED, allowedCaster, duration, withoutMana, onlyCastAllowed);
        effect.setTargetPointer(new FixedTargets(cardsToPlay, game));
        game.addEffect(effect, source);
        if (anyColor) {
            for (Card card2 : cardsToPlay) {
                game.addEffect(new YouMaySpendManaAsAnyColorToCastTargetEffect(duration).setTargetPointer(new FixedTarget(card2, game)), source);
            }
        }
        return true;
    }
}

