/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.combat;

import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.RequirementEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.permanent.Permanent;

public class BlocksIfAbleTargetEffect
extends RequirementEffect {
    public BlocksIfAbleTargetEffect(Duration duration) {
        super(duration);
    }

    protected BlocksIfAbleTargetEffect(BlocksIfAbleTargetEffect effect) {
        super(effect);
    }

    @Override
    public BlocksIfAbleTargetEffect copy() {
        return new BlocksIfAbleTargetEffect(this);
    }

    @Override
    public boolean applies(Permanent permanent, Ability source, Game game) {
        return this.getTargetPointer().getTargets(game, source).contains(permanent.getId());
    }

    @Override
    public boolean mustAttack(Game game) {
        return false;
    }

    @Override
    public boolean mustBlock(Game game) {
        return false;
    }

    @Override
    public boolean mustBlockAny(Game game) {
        return true;
    }

    @Override
    public String getText(Mode mode) {
        if (this.staticText != null && !this.staticText.isEmpty()) {
            return this.staticText;
        }
        return this.getTargetPointer().describeTargets(mode.getTargets(), "it") + (this.getTargetPointer().isPlural(mode.getTargets()) ? " block " : " blocks ") + (this.duration == Duration.EndOfTurn ? "this" : "each") + " turn if able";
    }
}

