/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.combat;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

public class CanBlockAdditionalCreatureEffect
extends ContinuousEffectImpl {
    protected int amount;

    public CanBlockAdditionalCreatureEffect() {
        this(1);
    }

    public CanBlockAdditionalCreatureEffect(int amount) {
        this(Duration.WhileOnBattlefield, amount);
    }

    public CanBlockAdditionalCreatureEffect(Duration duration, int amount) {
        super(duration, Outcome.Benefit);
        this.amount = amount;
        this.staticText = this.setText();
    }

    protected CanBlockAdditionalCreatureEffect(CanBlockAdditionalCreatureEffect effect) {
        super(effect);
        this.amount = effect.amount;
    }

    @Override
    public CanBlockAdditionalCreatureEffect copy() {
        return new CanBlockAdditionalCreatureEffect(this);
    }

    @Override
    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (permanent != null) {
            if (this.amount > 0) {
                if (permanent.getMaxBlocks() > 0) {
                    permanent.setMaxBlocks(permanent.getMaxBlocks() + this.amount);
                }
            } else {
                permanent.setMaxBlocks(0);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean apply(Game game, Ability source) {
        return false;
    }

    private String setText() {
        StringBuilder sb = new StringBuilder("{this} can block ");
        if (this.amount == 0) {
            sb.append("any number of creatures");
        } else {
            sb.append(CardUtil.numberToText(this.amount, "an"));
            sb.append(" additional creature");
            sb.append(this.amount > 1 ? "s" : "");
        }
        if (this.duration == Duration.EndOfTurn) {
            sb.append(" this turn");
        }
        if (this.duration == Duration.WhileOnBattlefield && this.amount == 1) {
            sb.append(" each combat");
        }
        return sb.toString();
    }

    @Override
    public boolean hasLayer(Layer layer) {
        return layer == Layer.RulesEffects;
    }
}

