/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.combat;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

public class GoadTargetEffect
extends ContinuousEffectImpl {
    public static String goadReminderText = "<i>(Until your next turn, that creature attacks each combat if able and attacks a player other than you if able.)</i>";

    public GoadTargetEffect() {
        this(Duration.UntilYourNextTurn);
    }

    public GoadTargetEffect(Duration duration) {
        super(duration, Layer.RulesEffects, SubLayer.NA, Outcome.Detriment);
    }

    protected GoadTargetEffect(GoadTargetEffect effect) {
        super(effect);
    }

    @Override
    public GoadTargetEffect copy() {
        return new GoadTargetEffect(this);
    }

    @Override
    public void init(Ability source, Game game) {
        super.init(source, game);
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return;
        }
        for (UUID targetId : this.getTargetPointer().getTargets(game, source)) {
            Permanent targetCreature = game.getPermanent(targetId);
            if (targetCreature == null) continue;
            game.informPlayers(controller.getLogName() + " is goading " + targetCreature.getLogName());
        }
    }

    @Override
    public boolean apply(Game game, Ability source) {
        for (UUID targetId : this.getTargetPointer().getTargets(game, source)) {
            Permanent targetCreature = game.getPermanent(targetId);
            if (targetCreature == null) continue;
            targetCreature.addGoadingPlayer(source.getControllerId());
        }
        return true;
    }

    @Override
    public String getText(Mode mode) {
        if (this.staticText != null && !this.staticText.isEmpty()) {
            return this.staticText;
        }
        return "goad " + this.getTargetPointer().describeTargets(mode.getTargets(), "that creature") + ". " + goadReminderText;
    }
}

