/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.combat;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.RequirementEffect;
import mage.constants.Duration;
import mage.filter.FilterPermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;

public class MustBeBlockedByAtLeastOneAttachedEffect
extends RequirementEffect {
    private final FilterPermanent filter;

    public MustBeBlockedByAtLeastOneAttachedEffect() {
        this((FilterPermanent)null);
    }

    public MustBeBlockedByAtLeastOneAttachedEffect(FilterPermanent filter) {
        super(Duration.WhileOnBattlefield);
        this.filter = filter;
        this.staticText = filter == null ? "must be blocked if able" : "must be blocked by " + filter.getMessage() + " if able";
    }

    protected MustBeBlockedByAtLeastOneAttachedEffect(MustBeBlockedByAtLeastOneAttachedEffect effect) {
        super(effect);
        this.filter = effect.filter;
    }

    @Override
    public boolean applies(Permanent permanent, Ability source, Game game) {
        Permanent attachment = game.getPermanent(source.getSourceId());
        if (attachment == null || attachment.getAttachedTo() == null) {
            return false;
        }
        Permanent attachedCreature = game.getPermanent(attachment.getAttachedTo());
        if (attachedCreature != null && attachedCreature.isAttacking() && permanent.canBlock(attachment.getAttachedTo(), game)) {
            return this.filter == null || this.filter.match(permanent, attachment.getControllerId(), source, game);
        }
        return false;
    }

    @Override
    public boolean mustAttack(Game game) {
        return false;
    }

    @Override
    public boolean mustBlock(Game game) {
        return false;
    }

    @Override
    public UUID mustBlockAttackerIfElseUnblocked(Ability source, Game game) {
        Permanent attachment = game.getPermanent(source.getSourceId());
        return attachment == null ? null : attachment.getAttachedTo();
    }

    @Override
    public int getMinNumberOfBlockers() {
        return this.filter == null ? 1 : 0;
    }

    @Override
    public MustBeBlockedByAtLeastOneAttachedEffect copy() {
        return new MustBeBlockedByAtLeastOneAttachedEffect(this);
    }
}

