/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.continuous;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.mana.BasicManaAbility;
import mage.abilities.mana.BlackManaAbility;
import mage.abilities.mana.BlueManaAbility;
import mage.abilities.mana.GreenManaAbility;
import mage.abilities.mana.RedManaAbility;
import mage.abilities.mana.WhiteManaAbility;
import mage.constants.DependencyType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;

public class AddBasicLandTypeAllLandsEffect
extends ContinuousEffectImpl {
    private final SubType subType;

    public AddBasicLandTypeAllLandsEffect(SubType subType) {
        super(Duration.WhileOnBattlefield, Layer.TypeChangingEffects_4, SubLayer.NA, Outcome.AIDontUseIt);
        this.subType = subType;
        this.staticText = "Each land is " + subType.getIndefiniteArticle() + " " + subType.getDescription() + " in addition to its other land types";
        this.dependendToTypes.add(DependencyType.BecomeNonbasicLand);
        switch (subType) {
            case PLAINS: {
                this.dependencyTypes.add(DependencyType.BecomePlains);
                break;
            }
            case ISLAND: {
                this.dependencyTypes.add(DependencyType.BecomeIsland);
                break;
            }
            case SWAMP: {
                this.dependencyTypes.add(DependencyType.BecomeSwamp);
                break;
            }
            case MOUNTAIN: {
                this.dependencyTypes.add(DependencyType.BecomeMountain);
                break;
            }
            case FOREST: {
                this.dependencyTypes.add(DependencyType.BecomeForest);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Subtype should be a basic land type");
            }
        }
    }

    private AddBasicLandTypeAllLandsEffect(AddBasicLandTypeAllLandsEffect effect) {
        super(effect);
        this.subType = effect.subType;
    }

    @Override
    public AddBasicLandTypeAllLandsEffect copy() {
        return new AddBasicLandTypeAllLandsEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        BasicManaAbility ability;
        switch (this.subType) {
            case PLAINS: {
                ability = new WhiteManaAbility();
                break;
            }
            case ISLAND: {
                ability = new BlueManaAbility();
                break;
            }
            case SWAMP: {
                ability = new BlackManaAbility();
                break;
            }
            case MOUNTAIN: {
                ability = new RedManaAbility();
                break;
            }
            case FOREST: {
                ability = new GreenManaAbility();
                break;
            }
            default: {
                ability = null;
            }
        }
        for (Permanent land : game.getBattlefield().getActivePermanents(StaticFilters.FILTER_LAND, source.getControllerId(), game)) {
            land.addSubType(game, this.subType);
            if (ability == null || land.getAbilities().containsRule(ability)) continue;
            land.addAbility(ability, source.getSourceId(), game);
        }
        return true;
    }
}

