/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.continuous;

import java.util.Locale;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.AttachmentType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SuperType;
import mage.game.Game;
import mage.game.permanent.Permanent;

public class AddCardSuperTypeAttachedEffect
extends ContinuousEffectImpl {
    private final SuperType addedSuperType;
    private final AttachmentType attachmentType;

    public AddCardSuperTypeAttachedEffect(SuperType addedSuperType, Duration duration, AttachmentType attachmentType) {
        super(duration, Layer.TypeChangingEffects_4, SubLayer.NA, Outcome.Benefit);
        this.addedSuperType = addedSuperType;
        this.attachmentType = attachmentType;
        this.setText();
    }

    protected AddCardSuperTypeAttachedEffect(AddCardSuperTypeAttachedEffect effect) {
        super(effect);
        this.addedSuperType = effect.addedSuperType;
        this.attachmentType = effect.attachmentType;
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Permanent target;
        Permanent equipment = game.getPermanent(source.getSourceId());
        if (equipment != null && equipment.getAttachedTo() != null && (target = game.getPermanent(equipment.getAttachedTo())) != null) {
            target.addSuperType(game, this.addedSuperType);
        }
        return true;
    }

    @Override
    public AddCardSuperTypeAttachedEffect copy() {
        return new AddCardSuperTypeAttachedEffect(this);
    }

    private void setText() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.attachmentType.verb());
        sb.append(" permanent is ").append(this.addedSuperType.toString().toLowerCase(Locale.ENGLISH));
        this.staticText = sb.toString();
    }
}

