/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.continuous;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.CardType;
import mage.constants.DependencyType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

public class AddCardTypeSourceEffect
extends ContinuousEffectImpl {
    private final List<CardType> addedCardTypes = new ArrayList<CardType>();

    public AddCardTypeSourceEffect(Duration duration, CardType ... addedCardType) {
        super(duration, Layer.TypeChangingEffects_4, SubLayer.NA, Outcome.Benefit);
        if (addedCardType.length == 0) {
            throw new IllegalArgumentException("AddCardTypeSourceEffect should be called with at least one card type.");
        }
        for (CardType cardType : addedCardType) {
            this.addedCardTypes.add(cardType);
            if (cardType == CardType.ENCHANTMENT) {
                this.dependencyTypes.add(DependencyType.EnchantmentAddingRemoving);
                continue;
            }
            if (cardType == CardType.ARTIFACT) {
                this.dependencyTypes.add(DependencyType.ArtifactAddingRemoving);
                continue;
            }
            if (cardType != CardType.LAND) continue;
            this.dependencyTypes.add(DependencyType.BecomeNonbasicLand);
        }
    }

    protected AddCardTypeSourceEffect(AddCardTypeSourceEffect effect) {
        super(effect);
        this.addedCardTypes.addAll(effect.addedCardTypes);
    }

    @Override
    public void init(Ability source, Game game) {
        super.init(source, game);
        this.affectedObjectList.add(new MageObjectReference(source.getSourceId(), game.getState().getZoneChangeCounter(source.getSourceId()), game));
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (permanent != null && (this.affectedObjectList.contains(new MageObjectReference(permanent, game)) || !this.duration.isOnlyValidIfNoZoneChange())) {
            for (CardType cardType : this.addedCardTypes) {
                permanent.addCardType(game, cardType);
            }
            return true;
        }
        if (this.getDuration() == Duration.Custom) {
            this.discard();
        }
        return false;
    }

    @Override
    public AddCardTypeSourceEffect copy() {
        return new AddCardTypeSourceEffect(this);
    }

    @Override
    public String getText(Mode mode) {
        if (this.staticText != null && !this.staticText.isEmpty()) {
            return this.staticText;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("{this} becomes ");
        sb.append(CardUtil.addArticle(this.addedCardTypes.stream().map(CardType::toString).map(String::toLowerCase).collect(Collectors.joining(" "))));
        if (!this.addedCardTypes.contains((Object)CardType.ARTIFACT) || !this.addedCardTypes.contains((Object)CardType.CREATURE)) {
            sb.append(" in addition to its other types");
        }
        if (!this.getDuration().toString().isEmpty()) {
            sb.append(' ');
            sb.append((Object)this.getDuration());
        }
        return sb.toString();
    }
}

