/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.continuous;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.effects.common.ChooseCreatureTypeEffect;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;

public class AddChosenSubtypeEffect
extends ContinuousEffectImpl {
    public AddChosenSubtypeEffect() {
        super(Duration.WhileOnBattlefield, Layer.TypeChangingEffects_4, SubLayer.NA, Outcome.Benefit);
        this.staticText = "{this} is the chosen type in addition to its other types";
    }

    protected AddChosenSubtypeEffect(AddChosenSubtypeEffect effect) {
        super(effect);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        SubType subType;
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (permanent != null && (subType = ChooseCreatureTypeEffect.getChosenCreatureType(permanent.getId(), game)) != null) {
            permanent.addSubType(game, subType);
        }
        return true;
    }

    @Override
    public AddChosenSubtypeEffect copy() {
        return new AddChosenSubtypeEffect(this);
    }
}

