/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.continuous;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.mana.BlackManaAbility;
import mage.abilities.mana.BlueManaAbility;
import mage.abilities.mana.GreenManaAbility;
import mage.abilities.mana.RedManaAbility;
import mage.abilities.mana.WhiteManaAbility;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.constants.SubTypeSet;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

public class BecomesBasicLandEnchantedEffect
extends ContinuousEffectImpl {
    protected List<SubType> landTypes = new ArrayList<SubType>();

    public BecomesBasicLandEnchantedEffect(SubType ... landNames) {
        super(Duration.WhileOnBattlefield, Layer.TypeChangingEffects_4, SubLayer.NA, Outcome.Detriment);
        this.landTypes.addAll(Arrays.asList(landNames));
        this.staticText = "enchanted land is " + CardUtil.addArticle(CardUtil.concatWithAnd(this.landTypes.stream().map(SubType::getDescription).collect(Collectors.toList())));
    }

    protected BecomesBasicLandEnchantedEffect(BecomesBasicLandEnchantedEffect effect) {
        super(effect);
        this.landTypes.addAll(effect.landTypes);
    }

    @Override
    public BecomesBasicLandEnchantedEffect copy() {
        return new BecomesBasicLandEnchantedEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Permanent enchantment = game.getPermanent(source.getSourceId());
        if (enchantment == null || enchantment.getAttachedTo() == null) {
            return false;
        }
        Permanent permanent = game.getPermanent(enchantment.getAttachedTo());
        if (permanent == null) {
            return false;
        }
        permanent.removeAllSubTypes(game, SubTypeSet.NonBasicLandType);
        permanent.addSubType(game, this.landTypes);
        permanent.removeAllAbilities(source.getSourceId(), game);
        for (SubType landType : this.landTypes) {
            switch (landType) {
                case PLAINS: {
                    if (!permanent.hasSubtype(SubType.PLAINS, game)) break;
                    permanent.addAbility(new WhiteManaAbility(), source.getSourceId(), game);
                    break;
                }
                case ISLAND: {
                    if (!permanent.hasSubtype(SubType.ISLAND, game)) break;
                    permanent.addAbility(new BlueManaAbility(), source.getSourceId(), game);
                    break;
                }
                case SWAMP: {
                    if (!permanent.hasSubtype(SubType.SWAMP, game)) break;
                    permanent.addAbility(new BlackManaAbility(), source.getSourceId(), game);
                    break;
                }
                case MOUNTAIN: {
                    if (!permanent.hasSubtype(SubType.MOUNTAIN, game)) break;
                    permanent.addAbility(new RedManaAbility(), source.getSourceId(), game);
                    break;
                }
                case FOREST: {
                    if (!permanent.hasSubtype(SubType.FOREST, game)) break;
                    permanent.addAbility(new GreenManaAbility(), source.getSourceId(), game);
                }
            }
        }
        return true;
    }
}

