/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.continuous;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import mage.abilities.Abilities;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.mana.BlackManaAbility;
import mage.abilities.mana.BlueManaAbility;
import mage.abilities.mana.GreenManaAbility;
import mage.abilities.mana.RedManaAbility;
import mage.abilities.mana.WhiteManaAbility;
import mage.choices.ChoiceBasicLandType;
import mage.constants.CardType;
import mage.constants.DependencyType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.constants.SubTypeSet;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

public class BecomesBasicLandTargetEffect
extends ContinuousEffectImpl {
    protected boolean chooseLandType;
    protected List<SubType> landTypes = new ArrayList<SubType>();
    private final boolean loseOther;

    public BecomesBasicLandTargetEffect(Duration duration) {
        this(duration, true, new SubType[0]);
    }

    public BecomesBasicLandTargetEffect(Duration duration, SubType ... landNames) {
        this(duration, false, landNames);
    }

    public BecomesBasicLandTargetEffect(Duration duration, boolean chooseLandType, SubType ... landNames) {
        this(duration, chooseLandType, true, landNames);
    }

    public BecomesBasicLandTargetEffect(Duration duration, boolean chooseLandType, boolean loseOther, SubType ... landNames) {
        super(duration, Layer.TypeChangingEffects_4, SubLayer.NA, Outcome.Detriment);
        this.landTypes.addAll(Arrays.asList(landNames));
        if (this.landTypes.contains((Object)SubType.MOUNTAIN)) {
            this.dependencyTypes.add(DependencyType.BecomeMountain);
        }
        if (this.landTypes.contains((Object)SubType.FOREST)) {
            this.dependencyTypes.add(DependencyType.BecomeForest);
        }
        if (this.landTypes.contains((Object)SubType.SWAMP)) {
            this.dependencyTypes.add(DependencyType.BecomeSwamp);
        }
        if (this.landTypes.contains((Object)SubType.ISLAND)) {
            this.dependencyTypes.add(DependencyType.BecomeIsland);
        }
        if (this.landTypes.contains((Object)SubType.PLAINS)) {
            this.dependencyTypes.add(DependencyType.BecomePlains);
        }
        this.chooseLandType = chooseLandType;
        this.loseOther = loseOther;
    }

    protected BecomesBasicLandTargetEffect(BecomesBasicLandTargetEffect effect) {
        super(effect);
        this.landTypes.addAll(effect.landTypes);
        this.chooseLandType = effect.chooseLandType;
        this.loseOther = effect.loseOther;
    }

    @Override
    public BecomesBasicLandTargetEffect copy() {
        return new BecomesBasicLandTargetEffect(this);
    }

    @Override
    public void init(Ability source, Game game) {
        super.init(source, game);
        if (this.chooseLandType) {
            this.chooseLandType(source, game);
        }
    }

    protected void chooseLandType(Ability source, Game game) {
        Player controller = game.getPlayer(source.getControllerId());
        ChoiceBasicLandType choice = new ChoiceBasicLandType();
        if (controller != null && controller.choose(this.outcome, choice, game)) {
            this.landTypes.add(SubType.byDescription(choice.getChoice()));
        } else {
            this.discard();
        }
    }

    @Override
    public boolean apply(Game game, Ability source) {
        for (UUID targetPermanent : this.getTargetPointer().getTargets(game, source)) {
            Permanent land = game.getPermanent(targetPermanent);
            if (land == null) continue;
            if (!land.isLand(game)) {
                land.addCardType(game, CardType.LAND);
            }
            if (this.loseOther) {
                land.removeAllAbilities(source.getSourceId(), game);
                land.removeAllSubTypes(game, SubTypeSet.NonBasicLandType);
            }
            land.addSubType(game, this.landTypes);
            Abilities<Ability> landAbilities = land.getAbilities(game);
            for (SubType landType : this.landTypes) {
                switch (landType) {
                    case PLAINS: {
                        if (landAbilities.containsClass(WhiteManaAbility.class)) break;
                        land.addAbility(new WhiteManaAbility(), source.getSourceId(), game);
                        break;
                    }
                    case ISLAND: {
                        if (landAbilities.containsClass(BlueManaAbility.class)) break;
                        land.addAbility(new BlueManaAbility(), source.getSourceId(), game);
                        break;
                    }
                    case SWAMP: {
                        if (landAbilities.containsClass(BlackManaAbility.class)) break;
                        land.addAbility(new BlackManaAbility(), source.getSourceId(), game);
                        break;
                    }
                    case MOUNTAIN: {
                        if (landAbilities.containsClass(RedManaAbility.class)) break;
                        land.addAbility(new RedManaAbility(), source.getSourceId(), game);
                        break;
                    }
                    case FOREST: {
                        if (landAbilities.containsClass(GreenManaAbility.class)) break;
                        land.addAbility(new GreenManaAbility(), source.getSourceId(), game);
                    }
                }
            }
        }
        return true;
    }

    @Override
    public String getText(Mode mode) {
        if (this.staticText != null && !this.staticText.isEmpty()) {
            return this.staticText;
        }
        StringBuilder sb = new StringBuilder(this.getTargetPointer().describeTargets(mode.getTargets(), "target land"));
        sb.append(" becomes ");
        if (this.chooseLandType) {
            sb.append("the basic land type of your choice");
        } else {
            sb.append(CardUtil.addArticle(CardUtil.concatWithAnd(this.landTypes.stream().map(SubType::getDescription).collect(Collectors.toList()))));
        }
        if (!this.loseOther) {
            sb.append(" in addition to its other types");
        }
        if (!this.duration.toString().isEmpty() && this.duration != Duration.EndOfGame) {
            sb.append(' ').append((Object)this.duration);
        }
        return sb.toString();
    }
}

