/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.continuous;

import java.util.HashSet;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.CardType;
import mage.constants.DependencyType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SuperType;
import mage.filter.FilterPermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.Token;

public class BecomesCreatureAllEffect
extends ContinuousEffectImpl {
    protected Token token;
    protected String theyAreStillType;
    private final FilterPermanent filter;
    private final boolean loseColor;
    private final boolean loseTypes;
    private final boolean loseName;

    public BecomesCreatureAllEffect(Token token, String theyAreStillType, FilterPermanent filter, Duration duration, boolean loseColor) {
        this(token, theyAreStillType, filter, duration, loseColor, false, false);
    }

    public BecomesCreatureAllEffect(Token token, String theyAreStillType, FilterPermanent filter, Duration duration, boolean loseColor, boolean loseName, boolean loseTypes) {
        super(duration, Outcome.BecomeCreature);
        this.token = token;
        this.theyAreStillType = theyAreStillType;
        this.filter = filter;
        this.loseColor = loseColor;
        this.loseName = loseName;
        this.loseTypes = loseTypes;
        this.dependencyTypes.add(DependencyType.BecomeCreature);
    }

    protected BecomesCreatureAllEffect(BecomesCreatureAllEffect effect) {
        super(effect);
        this.token = effect.token.copy();
        this.theyAreStillType = effect.theyAreStillType;
        this.filter = effect.filter.copy();
        this.loseColor = effect.loseColor;
        this.loseName = effect.loseName;
        this.loseTypes = effect.loseTypes;
    }

    @Override
    public void init(Ability source, Game game) {
        super.init(source, game);
        if (this.getAffectedObjectsSet()) {
            for (Permanent perm : game.getBattlefield().getActivePermanents(this.filter, source.getControllerId(), source, game)) {
                this.affectedObjectList.add(new MageObjectReference(perm, game));
            }
        }
    }

    @Override
    public BecomesCreatureAllEffect copy() {
        return new BecomesCreatureAllEffect(this);
    }

    /*
     * Could not resolve type clashes
     */
    @Override
    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        HashSet<Permanent> affectedPermanents = new HashSet<Permanent>();
        if (this.getAffectedObjectsSet()) {
            for (MageObjectReference ref : this.affectedObjectList) {
                affectedPermanents.add(ref.getPermanent(game));
            }
        } else {
            affectedPermanents = new HashSet<Permanent>(game.getBattlefield().getActivePermanents(this.filter, source.getControllerId(), source, game));
        }
        block8: for (Permanent permanent : affectedPermanents) {
            if (permanent == null) continue;
            switch (layer) {
                case TextChangingEffects_3: {
                    if (!this.loseName) break;
                    permanent.setName(this.token.getName());
                    break;
                }
                case TypeChangingEffects_4: {
                    for (Enum t : this.token.getCardType(game)) {
                        permanent.addCardType(game, new CardType[]{t});
                    }
                    if (this.theyAreStillType != null || this.loseTypes) {
                        permanent.removeAllCreatureTypes(game);
                    }
                    permanent.copySubTypesFrom(game, this.token);
                    for (Enum t : this.token.getSuperType(game)) {
                        permanent.addSuperType(game, (SuperType)t);
                    }
                    continue block8;
                }
                case ColorChangingEffects_5: {
                    if (this.loseColor) {
                        permanent.getColor(game).setWhite(false);
                        permanent.getColor(game).setBlue(false);
                        permanent.getColor(game).setBlack(false);
                        permanent.getColor(game).setRed(false);
                        permanent.getColor(game).setGreen(false);
                    }
                    if (!this.token.getColor(game).hasColor()) break;
                    permanent.getColor(game).addColor(this.token.getColor(game));
                    break;
                }
                case AbilityAddingRemovingEffects_6: {
                    if (this.token.getAbilities().isEmpty()) break;
                    for (Ability ability : this.token.getAbilities()) {
                        permanent.addAbility(ability, source.getSourceId(), game, true);
                    }
                    continue block8;
                }
                case PTChangingEffects_7: {
                    if (sublayer != SubLayer.SetPT_7b) break;
                    int power = this.token.getPower().getValue();
                    int toughness = this.token.getToughness().getValue();
                    if (power == 0 || toughness == 0) break;
                    permanent.getPower().setModifiedBaseValue(power);
                    permanent.getToughness().setModifiedBaseValue(toughness);
                }
            }
        }
        return true;
    }

    @Override
    public boolean apply(Game game, Ability source) {
        return false;
    }

    @Override
    public boolean hasLayer(Layer layer) {
        return layer == Layer.PTChangingEffects_7 || layer == Layer.AbilityAddingRemovingEffects_6 || layer == Layer.ColorChangingEffects_5 || layer == Layer.TypeChangingEffects_4 || layer == Layer.TextChangingEffects_3;
    }

    @Override
    public String getText(Mode mode) {
        if (this.staticText != null && !this.staticText.isEmpty()) {
            return this.staticText;
        }
        StringBuilder sb = new StringBuilder();
        if (this.duration.toString() != null && !this.duration.toString().isEmpty()) {
            sb.append(this.duration.toString()).append(", ");
        }
        sb.append(this.filter.getMessage());
        if (this.duration.toString() != null && this.duration.toString().isEmpty()) {
            sb.append(" are ");
        } else {
            sb.append(" become ");
        }
        sb.append(this.token.getDescription());
        if (this.theyAreStillType != null && !this.theyAreStillType.isEmpty()) {
            sb.append(" that are still ").append(this.theyAreStillType);
        }
        return sb.toString();
    }
}

