/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.continuous;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.CardType;
import mage.constants.DependencyType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SuperType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.Token;

public class BecomesCreatureAttachedEffect
extends ContinuousEffectImpl {
    protected Token token;
    protected String type;
    protected LoseType loseType;

    public BecomesCreatureAttachedEffect(Token token, String text, Duration duration) {
        this(token, text, duration, LoseType.NONE);
    }

    public BecomesCreatureAttachedEffect(Token token, String text, Duration duration, LoseType loseType) {
        super(duration, Layer.TypeChangingEffects_4, SubLayer.NA, Outcome.BecomeCreature);
        this.token = token;
        this.loseType = loseType;
        this.staticText = text;
    }

    public BecomesCreatureAttachedEffect(Token token, String text, Duration duration, LoseType loseType, Outcome outcome) {
        super(duration, Layer.TypeChangingEffects_4, SubLayer.NA, outcome);
        this.token = token;
        this.loseType = loseType;
        this.staticText = text;
        this.dependencyTypes.add(DependencyType.BecomeCreature);
    }

    protected BecomesCreatureAttachedEffect(BecomesCreatureAttachedEffect effect) {
        super(effect);
        this.token = effect.token.copy();
        this.type = effect.type;
        this.loseType = effect.loseType;
    }

    @Override
    public BecomesCreatureAttachedEffect copy() {
        return new BecomesCreatureAttachedEffect(this);
    }

    @Override
    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        Permanent enchantment = game.getPermanent(source.getSourceId());
        if (enchantment == null) {
            return false;
        }
        Permanent permanent = game.getPermanent(enchantment.getAttachedTo());
        if (permanent == null) {
            return true;
        }
        switch (layer) {
            case TypeChangingEffects_4: {
                for (SuperType superType : this.token.getSuperType(game)) {
                    permanent.addSuperType(game, superType);
                }
                switch (this.loseType) {
                    case ALL: 
                    case ALL_BUT_COLOR: {
                        permanent.removeAllCardTypes(game);
                    }
                }
                for (CardType cardType : this.token.getCardType(game)) {
                    permanent.addCardType(game, cardType);
                }
                switch (this.loseType) {
                    case ALL: 
                    case ALL_BUT_COLOR: {
                        permanent.removeAllSubTypes(game);
                        break;
                    }
                    case ABILITIES_SUBTYPE: {
                        permanent.removeAllCreatureTypes(game);
                    }
                }
                permanent.copySubTypesFrom(game, this.token);
                break;
            }
            case ColorChangingEffects_5: {
                if (this.loseType == LoseType.ALL || this.loseType == LoseType.COLOR) {
                    permanent.getColor(game).setWhite(false);
                    permanent.getColor(game).setBlue(false);
                    permanent.getColor(game).setBlack(false);
                    permanent.getColor(game).setRed(false);
                    permanent.getColor(game).setGreen(false);
                }
                if (!this.token.getColor(game).hasColor()) break;
                permanent.getColor(game).addColor(this.token.getColor(game));
                break;
            }
            case AbilityAddingRemovingEffects_6: {
                switch (this.loseType) {
                    case ALL: 
                    case ALL_BUT_COLOR: 
                    case ABILITIES_SUBTYPE: 
                    case ABILITIES: {
                        permanent.removeAllAbilities(source.getSourceId(), game);
                    }
                }
                for (Ability ability : this.token.getAbilities()) {
                    permanent.addAbility(ability, source.getSourceId(), game, true);
                }
                break;
            }
            case PTChangingEffects_7: {
                if (sublayer != SubLayer.SetPT_7b) break;
                permanent.getPower().setModifiedBaseValue(this.token.getPower().getValue());
                permanent.getToughness().setModifiedBaseValue(this.token.getToughness().getValue());
            }
        }
        return true;
    }

    @Override
    public boolean apply(Game game, Ability source) {
        return false;
    }

    @Override
    public boolean hasLayer(Layer layer) {
        return layer == Layer.PTChangingEffects_7 || layer == Layer.AbilityAddingRemovingEffects_6 || layer == Layer.ColorChangingEffects_5 || layer == Layer.TypeChangingEffects_4;
    }

    public static enum LoseType {
        NONE,
        ALL,
        ALL_BUT_COLOR,
        ABILITIES,
        ABILITIES_SUBTYPE,
        COLOR;

    }
}

