/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.continuous;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.CardType;
import mage.constants.DependencyType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SuperType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.Token;
import mage.util.CardUtil;

public class BecomesCreatureTargetEffect
extends ContinuousEffectImpl {
    protected Token token;
    protected boolean loseAllAbilities;
    protected boolean addStillALandText;
    protected boolean loseName;
    protected boolean keepAbilities;
    protected boolean removeSubtypes = false;
    protected boolean loseOtherCardTypes;
    protected boolean durationRuleAtStart = false;

    public BecomesCreatureTargetEffect(Token token, boolean loseAllAbilities, boolean stillALand, Duration duration) {
        this(token, loseAllAbilities, stillALand, duration, false);
    }

    public BecomesCreatureTargetEffect(Token token, boolean loseAllAbilities, boolean stillALand, Duration duration, boolean loseName) {
        this(token, loseAllAbilities, stillALand, duration, loseName, false);
    }

    public BecomesCreatureTargetEffect(Token token, boolean loseAllAbilities, boolean stillALand, Duration duration, boolean loseName, boolean keepAbilities) {
        this(token, loseAllAbilities, stillALand, duration, loseName, keepAbilities, false);
    }

    public BecomesCreatureTargetEffect(Token token, boolean loseAllAbilities, boolean stillALand, Duration duration, boolean loseName, boolean keepAbilities, boolean loseOtherCardTypes) {
        super(duration, Outcome.BecomeCreature);
        this.token = token;
        this.loseAllAbilities = loseAllAbilities;
        this.addStillALandText = stillALand;
        this.loseName = loseName;
        this.keepAbilities = keepAbilities;
        this.loseOtherCardTypes = loseOtherCardTypes;
        this.dependencyTypes.add(DependencyType.BecomeCreature);
    }

    protected BecomesCreatureTargetEffect(BecomesCreatureTargetEffect effect) {
        super(effect);
        this.token = effect.token.copy();
        this.loseAllAbilities = effect.loseAllAbilities;
        this.addStillALandText = effect.addStillALandText;
        this.loseName = effect.loseName;
        this.keepAbilities = effect.keepAbilities;
        this.loseOtherCardTypes = effect.loseOtherCardTypes;
        this.dependencyTypes.add(DependencyType.BecomeCreature);
        this.durationRuleAtStart = effect.durationRuleAtStart;
        this.removeSubtypes = effect.removeSubtypes;
    }

    @Override
    public BecomesCreatureTargetEffect copy() {
        return new BecomesCreatureTargetEffect(this);
    }

    @Override
    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        boolean result = false;
        for (UUID permanentId : this.getTargetPointer().getTargets(game, source)) {
            Permanent permanent = game.getPermanent(permanentId);
            if (permanent == null) continue;
            switch (layer) {
                case TextChangingEffects_3: {
                    if (!this.loseName) break;
                    permanent.setName(this.token.getName());
                    break;
                }
                case TypeChangingEffects_4: {
                    if (this.loseOtherCardTypes) {
                        permanent.removeAllCardTypes(game);
                    }
                    if (this.loseAllAbilities) {
                        permanent.removeAllCreatureTypes(game);
                    }
                    if (this.keepAbilities || this.removeSubtypes) {
                        permanent.removeAllSubTypes(game);
                    }
                    for (CardType cardType : this.token.getCardType(game)) {
                        permanent.addCardType(game, cardType);
                    }
                    permanent.copySubTypesFrom(game, this.token);
                    for (SuperType superType : this.token.getSuperType(game)) {
                        permanent.addSuperType(game, superType);
                    }
                    break;
                }
                case ColorChangingEffects_5: {
                    if (this.loseAllAbilities) {
                        permanent.getColor(game).setWhite(false);
                        permanent.getColor(game).setBlue(false);
                        permanent.getColor(game).setBlack(false);
                        permanent.getColor(game).setRed(false);
                        permanent.getColor(game).setGreen(false);
                    }
                    if (!this.token.getColor(game).hasColor()) break;
                    permanent.getColor(game).setColor(this.token.getColor(game));
                    break;
                }
                case AbilityAddingRemovingEffects_6: {
                    if (this.loseAllAbilities && !this.keepAbilities) {
                        permanent.removeAllAbilities(source.getSourceId(), game);
                    }
                    if (sublayer != SubLayer.NA || this.token.getAbilities().isEmpty()) break;
                    for (Ability ability : this.token.getAbilities()) {
                        permanent.addAbility(ability, source.getSourceId(), game, true);
                    }
                    break;
                }
                case PTChangingEffects_7: {
                    if (sublayer != SubLayer.SetPT_7b) break;
                    permanent.getToughness().setModifiedBaseValue(this.token.getToughness().getValue());
                    permanent.getPower().setModifiedBaseValue(this.token.getPower().getValue());
                }
            }
            result = true;
        }
        if (!result && this.duration == Duration.Custom) {
            this.discard();
        }
        return result;
    }

    public BecomesCreatureTargetEffect setRemoveSubtypes(boolean removeSubtypes) {
        this.removeSubtypes = removeSubtypes;
        return this;
    }

    @Override
    public boolean apply(Game game, Ability source) {
        return false;
    }

    @Override
    public boolean hasLayer(Layer layer) {
        return layer == Layer.PTChangingEffects_7 || layer == Layer.AbilityAddingRemovingEffects_6 || layer == Layer.ColorChangingEffects_5 || layer == Layer.TypeChangingEffects_4 || layer == Layer.TextChangingEffects_3;
    }

    public BecomesCreatureTargetEffect withDurationRuleAtStart(boolean durationRuleAtStart) {
        this.durationRuleAtStart = durationRuleAtStart;
        return this;
    }

    @Override
    public String getText(Mode mode) {
        if (this.staticText != null && !this.staticText.isEmpty()) {
            return this.staticText;
        }
        StringBuilder sb = new StringBuilder();
        if (this.durationRuleAtStart && !this.duration.toString().isEmpty()) {
            sb.append(this.duration.toString());
            sb.append(", ");
        }
        sb.append(this.getTargetPointer().describeTargets(mode.getTargets(), "that creature"));
        sb.append(this.getTargetPointer().isPlural(mode.getTargets()) ? " each" : "");
        if (this.loseAllAbilities && !this.keepAbilities) {
            sb.append(this.getTargetPointer().isPlural(mode.getTargets()) ? " lose all their abilities and" : " loses all abilities and");
        }
        if (this.getTargetPointer().isPlural(mode.getTargets())) {
            sb.append(" become ").append(this.token.getDescription());
        } else {
            sb.append(" becomes ").append(CardUtil.addArticle(this.token.getDescription()));
        }
        if (!this.durationRuleAtStart && !this.duration.toString().isEmpty()) {
            sb.append(' ').append(this.duration.toString());
        }
        if (this.addStillALandText) {
            sb.append(this.getTargetPointer().isPlural(mode.getTargets()) ? ". They're still lands" : ". It's still a land");
        }
        return sb.toString().replace(" .", ".");
    }
}

