/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.continuous;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.MageObjectReference;
import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.common.TurnFaceUpAbility;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.keyword.MorphAbility;
import mage.cards.Card;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.filter.FilterPermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;

public class BecomesFaceDownCreatureAllEffect
extends ContinuousEffectImpl {
    protected Map<UUID, Ability> turnFaceUpAbilityMap = new HashMap<UUID, Ability>();
    protected FilterPermanent filter;

    public BecomesFaceDownCreatureAllEffect(FilterPermanent filter) {
        super(Duration.EndOfGame, Outcome.BecomeCreature);
        this.filter = filter;
        this.staticText = "turn all " + filter.getMessage() + " face down. (They're 2/2 creatures.)";
    }

    protected BecomesFaceDownCreatureAllEffect(BecomesFaceDownCreatureAllEffect effect) {
        super(effect);
        for (Map.Entry<UUID, Ability> entry : effect.turnFaceUpAbilityMap.entrySet()) {
            this.turnFaceUpAbilityMap.put(entry.getKey(), entry.getValue());
        }
        this.filter = effect.filter.copy();
    }

    @Override
    public BecomesFaceDownCreatureAllEffect copy() {
        return new BecomesFaceDownCreatureAllEffect(this);
    }

    @Override
    public void init(Ability source, Game game) {
        super.init(source, game);
        for (Permanent perm : game.getBattlefield().getActivePermanents(this.filter, source.getControllerId(), source, game)) {
            if (perm.isFaceDown(game) || perm.isTransformable()) continue;
            this.affectedObjectList.add(new MageObjectReference(perm, game));
            perm.setFaceDown(true, game);
            Card card = game.getCard(perm.getId());
            if (card == null) continue;
            for (Ability ability : card.getAbilities(game)) {
                if (!(ability instanceof MorphAbility)) continue;
                this.turnFaceUpAbilityMap.put(card.getId(), new TurnFaceUpAbility(((MorphAbility)ability).getFaceUpCosts()));
            }
        }
    }

    @Override
    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        boolean targetExists = false;
        for (MageObjectReference mor : this.affectedObjectList) {
            Permanent permanent = mor.getPermanent(game);
            if (permanent == null || !permanent.isFaceDown(game)) continue;
            targetExists = true;
            switch (layer) {
                case TypeChangingEffects_4: {
                    permanent.setName("");
                    permanent.removeAllSuperTypes(game);
                    permanent.removeAllCardTypes(game);
                    permanent.addCardType(game, CardType.CREATURE);
                    permanent.removeAllSubTypes(game);
                    permanent.getManaCost().clear();
                    break;
                }
                case ColorChangingEffects_5: {
                    permanent.getColor(game).setColor(new ObjectColor());
                    break;
                }
                case AbilityAddingRemovingEffects_6: {
                    Card card = game.getCard(permanent.getId());
                    ArrayList<Ability> abilitiesToRemove = new ArrayList<Ability>();
                    for (Ability ability : permanent.getAbilities()) {
                        if (card != null && !card.getAbilities().contains(ability)) continue;
                        if (ability.getWorksFaceDown()) {
                            ability.setRuleVisible(false);
                            continue;
                        }
                        if (!ability.getRuleVisible() && !ability.getEffects().isEmpty() && ability.getEffects().get(0) instanceof BecomesFaceDownCreatureAllEffect) continue;
                        abilitiesToRemove.add(ability);
                    }
                    permanent.removeAbilities(abilitiesToRemove, source.getSourceId(), game);
                    if (!this.turnFaceUpAbilityMap.containsKey(permanent.getId())) break;
                    permanent.addAbility(this.turnFaceUpAbilityMap.get(permanent.getId()), source.getSourceId(), game);
                    break;
                }
                case PTChangingEffects_7: {
                    if (sublayer != SubLayer.SetPT_7b) break;
                    permanent.getPower().setModifiedBaseValue(2);
                    permanent.getToughness().setModifiedBaseValue(2);
                }
            }
        }
        if (!targetExists) {
            this.discard();
        }
        return true;
    }

    @Override
    public boolean apply(Game game, Ability source) {
        return false;
    }

    @Override
    public boolean hasLayer(Layer layer) {
        return layer == Layer.PTChangingEffects_7 || layer == Layer.AbilityAddingRemovingEffects_6 || layer == Layer.ColorChangingEffects_5 || layer == Layer.TypeChangingEffects_4;
    }
}

