/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.continuous;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import mage.MageObject;
import mage.MageObjectReference;
import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.common.TurnFaceUpAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.CostAdjuster;
import mage.abilities.costs.Costs;
import mage.abilities.costs.CostsImpl;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.effects.common.InfoEffect;
import mage.abilities.keyword.WardAbility;
import mage.cards.Card;
import mage.cards.CardImpl;
import mage.cards.ModalDoubleFacedCard;
import mage.cards.repository.TokenInfo;
import mage.cards.repository.TokenRepository;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.EmptyNames;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.Rarity;
import mage.constants.SubLayer;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.EmptyToken;
import mage.util.CardUtil;
import org.apache.log4j.Logger;

public class BecomesFaceDownCreatureEffect
extends ContinuousEffectImpl {
    private static final Logger logger = Logger.getLogger(BecomesFaceDownCreatureEffect.class);
    protected int zoneChangeCounter;
    protected List<Ability> additionalAbilities = new ArrayList<Ability>();
    protected MageObjectReference objectReference = null;
    protected boolean foundPermanent;
    protected FaceDownType faceDownType;

    public BecomesFaceDownCreatureEffect(Duration duration, FaceDownType faceDownType) {
        this(null, null, duration, faceDownType);
    }

    public BecomesFaceDownCreatureEffect(Costs<Cost> turnFaceUpCosts, FaceDownType faceDownType) {
        this(turnFaceUpCosts, null, faceDownType);
    }

    public BecomesFaceDownCreatureEffect(Costs<Cost> turnFaceUpCosts, MageObjectReference objectReference, FaceDownType faceDownType) {
        this(turnFaceUpCosts, objectReference, Duration.WhileOnBattlefield, faceDownType);
    }

    public BecomesFaceDownCreatureEffect(Cost cost, MageObjectReference objectReference, Duration duration, FaceDownType faceDownType) {
        this(BecomesFaceDownCreatureEffect.createCosts(cost), objectReference, duration, faceDownType);
    }

    public BecomesFaceDownCreatureEffect(Costs<Cost> cost, MageObjectReference objectReference, Duration duration, FaceDownType faceDownType) {
        this(BecomesFaceDownCreatureEffect.createCosts(cost), objectReference, duration, faceDownType, null);
    }

    public BecomesFaceDownCreatureEffect(Cost cost, MageObjectReference objectReference, Duration duration, FaceDownType faceDownType, CostAdjuster costAdjuster) {
        this(BecomesFaceDownCreatureEffect.createCosts(cost), objectReference, duration, faceDownType, costAdjuster);
    }

    public BecomesFaceDownCreatureEffect(Costs<Cost> turnFaceUpCosts, MageObjectReference objectReference, Duration duration, FaceDownType faceDownType, CostAdjuster costAdjuster) {
        super(duration, Layer.CopyEffects_1, SubLayer.FaceDownEffects_1b, Outcome.BecomeCreature);
        this.objectReference = objectReference;
        this.zoneChangeCounter = Integer.MIN_VALUE;
        if (turnFaceUpCosts != null) {
            this.additionalAbilities.add(new TurnFaceUpAbility(turnFaceUpCosts, faceDownType == FaceDownType.MEGAMORPHED).setCostAdjuster(costAdjuster));
        }
        switch (faceDownType) {
            case MORPHED: 
            case MEGAMORPHED: {
                if (turnFaceUpCosts == null) break;
                this.additionalAbilities.add(new SimpleStaticAbility(Zone.ALL, new InfoEffect("Turn it face up any time for its morph cost.")));
                break;
            }
            case DISGUISED: 
            case CLOAKED: {
                this.additionalAbilities.add(new WardAbility(new ManaCostsImpl("{2}")));
                if (turnFaceUpCosts == null) break;
                this.additionalAbilities.add(new SimpleStaticAbility(Zone.ALL, new InfoEffect("Turn it face up any time for its disguise/cloaked cost.")));
                break;
            }
            case MANUAL: 
            case MANIFESTED: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Un-supported face down type: " + (Object)((Object)faceDownType));
            }
        }
        this.staticText = "{this} becomes a 2/2 face-down creature, with no text, no name, no subtypes, and no mana cost";
        this.foundPermanent = false;
        this.faceDownType = faceDownType;
    }

    protected BecomesFaceDownCreatureEffect(BecomesFaceDownCreatureEffect effect) {
        super(effect);
        this.zoneChangeCounter = effect.zoneChangeCounter;
        effect.additionalAbilities.forEach(ability -> this.additionalAbilities.add(ability.copy()));
        this.objectReference = effect.objectReference;
        this.foundPermanent = effect.foundPermanent;
        this.faceDownType = effect.faceDownType;
    }

    private static Costs<Cost> createCosts(Cost cost) {
        if (cost == null) {
            return null;
        }
        CostsImpl<Cost> costs = new CostsImpl<Cost>();
        costs.add(cost);
        return costs;
    }

    @Override
    public BecomesFaceDownCreatureEffect copy() {
        return new BecomesFaceDownCreatureEffect(this);
    }

    @Override
    public void init(Ability source, Game game) {
        Permanent permanent;
        super.init(source, game);
        if (this.faceDownType == FaceDownType.MANUAL && (permanent = this.objectReference != null ? this.objectReference.getPermanent(game) : game.getPermanent(source.getSourceId())) != null) {
            permanent.setFaceDown(true, game);
        }
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Permanent permanent = this.objectReference != null ? this.objectReference.getPermanent(game) : game.getPermanent(source.getSourceId());
        if (permanent != null && permanent.isFaceDown(game)) {
            if (!this.foundPermanent) {
                this.foundPermanent = true;
                switch (this.faceDownType) {
                    case MANUAL: 
                    case MANIFESTED: {
                        permanent.setManifested(true);
                        break;
                    }
                    case MORPHED: 
                    case MEGAMORPHED: {
                        permanent.setMorphed(true);
                        break;
                    }
                    case DISGUISED: {
                        permanent.setDisguised(true);
                        break;
                    }
                    case CLOAKED: {
                        permanent.setCloaked(true);
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("FaceDownType not yet supported: " + (Object)((Object)this.faceDownType));
                    }
                }
            }
            BecomesFaceDownCreatureEffect.makeFaceDownObject(game, source.getSourceId(), permanent, this.faceDownType, this.additionalAbilities);
        } else if (this.duration == Duration.Custom && this.foundPermanent) {
            this.discard();
        }
        return true;
    }

    public static FaceDownType findFaceDownType(Game game, Permanent permanent) {
        if (permanent.isMorphed()) {
            return FaceDownType.MORPHED;
        }
        if (permanent.isDisguised()) {
            return FaceDownType.DISGUISED;
        }
        if (permanent.isManifested()) {
            return FaceDownType.MANIFESTED;
        }
        if (permanent.isCloaked()) {
            return FaceDownType.CLOAKED;
        }
        if (permanent.isFaceDown(game)) {
            return FaceDownType.MANUAL;
        }
        return null;
    }

    public static void makeFaceDownObject(Game game, UUID sourceId, MageObject object, FaceDownType faceDownType, List<Ability> additionalAbilities) {
        String tokenName;
        String originalObjectInfo = object.toString();
        object.setName(EmptyNames.FACE_DOWN_CREATURE.getObjectName());
        object.removeAllSuperTypes();
        object.getSubtype().clear();
        object.removeAllCardTypes();
        object.addCardType(CardType.CREATURE);
        object.getColor().setColor(ObjectColor.COLORLESS);
        Card card = game.getCard(object.getId());
        ArrayList<Ability> abilitiesToRemove = new ArrayList<Ability>();
        for (Ability ability : object.getAbilities()) {
            if (card != null && !card.getAbilities().contains(ability)) continue;
            if (ability.getWorksFaceDown()) {
                ability.setRuleVisible(false);
                if (ability.getEffects().isEmpty() || !(ability.getEffects().get(0) instanceof BecomesFaceDownCreatureEffect)) continue;
                ability.setRuleVisible(true);
                continue;
            }
            abilitiesToRemove.add(ability);
        }
        if (object instanceof Permanent) {
            Permanent permanentObject = (Permanent)object;
            permanentObject.removeAbilities(abilitiesToRemove, sourceId, game);
            if (additionalAbilities != null) {
                additionalAbilities.forEach(blueprintAbility -> {
                    Ability newAbility = blueprintAbility.copy();
                    newAbility.setRuleVisible(CardUtil.isInformationAbility(newAbility));
                    permanentObject.addAbility(newAbility, sourceId, game);
                });
            }
        } else if (object instanceof CardImpl) {
            CardImpl cardObject = (CardImpl)object;
            cardObject.getAbilities().removeAll(abilitiesToRemove);
            if (additionalAbilities != null) {
                additionalAbilities.forEach(blueprintAbility -> {
                    Ability newAbility = blueprintAbility.copy();
                    newAbility.setRuleVisible(CardUtil.isInformationAbility(newAbility));
                    cardObject.addAbility(newAbility);
                });
            }
        }
        object.getPower().setModifiedBaseValue(2);
        object.getToughness().setModifiedBaseValue(2);
        switch (faceDownType) {
            case MORPHED: 
            case MEGAMORPHED: {
                tokenName = "Morph";
                break;
            }
            case DISGUISED: {
                tokenName = "Disguise";
                break;
            }
            case MANIFESTED: {
                tokenName = "Manifest";
                break;
            }
            case CLOAKED: {
                tokenName = "Cloak";
                break;
            }
            case MANUAL: {
                tokenName = "Face Down";
                break;
            }
            default: {
                throw new IllegalArgumentException("Un-supported face down type for image: " + (Object)((Object)faceDownType));
            }
        }
        EmptyToken faceDownToken = new EmptyToken();
        TokenInfo faceDownInfo = TokenRepository.instance.findPreferredTokenInfoForXmage(tokenName, object.getId());
        if (faceDownInfo != null) {
            faceDownToken.setExpansionSetCode(faceDownInfo.getSetCode());
            faceDownToken.setUsesVariousArt(false);
            faceDownToken.setCardNumber("0");
            faceDownToken.setImageFileName(faceDownInfo.getName());
            faceDownToken.setImageNumber(faceDownInfo.getImageNumber());
        } else {
            logger.error((Object)("Can't find face down image for " + tokenName + ": " + originalObjectInfo));
        }
        CardUtil.copySetAndCardNumber(object, faceDownToken);
        if (object instanceof Card) {
            ((Card)object).setRarity(Rarity.SPECIAL);
        }
    }

    public static Card findDefaultCardSideForFaceDown(Game game, Card card) {
        if (card instanceof ModalDoubleFacedCard) {
            return ((ModalDoubleFacedCard)card).getLeftHalfCard();
        }
        return card;
    }

    public static enum FaceDownType {
        MANIFESTED,
        MANUAL,
        MORPHED,
        MEGAMORPHED,
        DISGUISED,
        CLOAKED;

    }
}

