/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.continuous;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.filter.StaticFilters;
import mage.filter.common.FilterCreaturePermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;

public class BecomesSubtypeAllEffect
extends ContinuousEffectImpl {
    private final List<SubType> subtypes = new ArrayList<SubType>();
    private final boolean loseOther;
    private final FilterCreaturePermanent filter;

    public BecomesSubtypeAllEffect(Duration duration, SubType subtype) {
        this(duration, Arrays.asList(subtype));
    }

    public BecomesSubtypeAllEffect(Duration duration, List<SubType> subtypes) {
        this(duration, subtypes, StaticFilters.FILTER_PERMANENT_CREATURE, true);
    }

    public BecomesSubtypeAllEffect(Duration duration, List<SubType> subtypes, FilterCreaturePermanent filter, boolean loseOther) {
        super(duration, Layer.TypeChangingEffects_4, SubLayer.NA, Outcome.Detriment);
        this.subtypes.addAll(subtypes);
        this.staticText = this.setText();
        this.loseOther = loseOther;
        this.filter = filter;
    }

    protected BecomesSubtypeAllEffect(BecomesSubtypeAllEffect effect) {
        super(effect);
        this.subtypes.addAll(effect.subtypes);
        this.loseOther = effect.loseOther;
        this.filter = effect.filter;
    }

    @Override
    public BecomesSubtypeAllEffect copy() {
        return new BecomesSubtypeAllEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        boolean flag = false;
        for (Permanent permanent : game.getBattlefield().getActivePermanents(this.filter, source.getControllerId(), source, game)) {
            if (permanent == null) continue;
            flag = true;
            if (this.loseOther) {
                permanent.removeAllCreatureTypes(game);
            }
            for (SubType subtype : this.subtypes) {
                permanent.addSubType(game, subtype);
            }
        }
        if (!flag && this.duration == Duration.Custom) {
            this.discard();
        }
        return true;
    }

    private String setText() {
        StringBuilder sb = new StringBuilder();
        sb.append("Target creature becomes that type");
        if (!this.duration.toString().isEmpty() && this.duration != Duration.EndOfGame) {
            sb.append(' ').append(this.duration.toString());
        }
        return sb.toString();
    }
}

