/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.continuous;

import java.util.Iterator;
import java.util.Set;
import java.util.UUID;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.filter.StaticFilters;
import mage.filter.common.FilterCreaturePermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

public class BoostOpponentsEffect
extends ContinuousEffectImpl {
    protected int power;
    protected int toughness;
    protected FilterCreaturePermanent filter;

    public BoostOpponentsEffect(int power, int toughness, Duration duration) {
        this(power, toughness, duration, StaticFilters.FILTER_PERMANENT_CREATURES);
    }

    public BoostOpponentsEffect(int power, int toughness, Duration duration, FilterCreaturePermanent filter) {
        super(duration, Layer.PTChangingEffects_7, SubLayer.ModifyPT_7c, toughness < 0 ? Outcome.UnboostCreature : Outcome.BoostCreature);
        this.power = power;
        this.toughness = toughness;
        this.filter = filter;
        this.setText();
    }

    protected BoostOpponentsEffect(BoostOpponentsEffect effect) {
        super(effect);
        this.power = effect.power;
        this.toughness = effect.toughness;
        this.filter = effect.filter.copy();
    }

    @Override
    public BoostOpponentsEffect copy() {
        return new BoostOpponentsEffect(this);
    }

    @Override
    public void init(Ability source, Game game) {
        super.init(source, game);
        if (this.getAffectedObjectsSet()) {
            Set<UUID> opponents = game.getOpponents(source.getControllerId());
            for (Permanent perm : game.getBattlefield().getActivePermanents(this.filter, source.getControllerId(), source, game)) {
                if (!opponents.contains(perm.getControllerId())) continue;
                this.affectedObjectList.add(new MageObjectReference(perm, game));
            }
        }
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Set<UUID> opponents = game.getOpponents(source.getControllerId());
        if (this.getAffectedObjectsSet()) {
            Iterator it = this.affectedObjectList.iterator();
            while (it.hasNext()) {
                Permanent perm = ((MageObjectReference)it.next()).getPermanent(game);
                if (perm != null) {
                    if (!opponents.contains(perm.getControllerId())) continue;
                    perm.addPower(this.power);
                    perm.addToughness(this.toughness);
                    continue;
                }
                it.remove();
            }
        } else {
            for (Permanent perm : game.getBattlefield().getActivePermanents(this.filter, source.getControllerId(), source, game)) {
                if (!opponents.contains(perm.getControllerId())) continue;
                perm.addPower(this.power);
                perm.addToughness(this.toughness);
            }
        }
        return true;
    }

    private void setText() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.filter.getMessage());
        sb.append(" your opponents control get ").append(CardUtil.getBoostCountAsStr(this.power, this.toughness));
        sb.append(this.duration == Duration.EndOfTurn ? " until end of turn" : "");
        this.staticText = sb.toString();
    }
}

