/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.continuous;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.cards.Card;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.game.Game;

public class CastAsThoughItHadFlashAllEffect
extends AsThoughEffectImpl {
    private final FilterCard filter;
    private final boolean anyPlayer;

    public CastAsThoughItHadFlashAllEffect(Duration duration, FilterCard filter) {
        this(duration, filter, false);
    }

    public CastAsThoughItHadFlashAllEffect(Duration duration, FilterCard filter, boolean anyPlayer) {
        super(AsThoughEffectType.CAST_AS_INSTANT, duration, Outcome.Benefit);
        this.filter = filter;
        this.anyPlayer = anyPlayer;
        this.staticText = this.setText();
    }

    protected CastAsThoughItHadFlashAllEffect(CastAsThoughItHadFlashAllEffect effect) {
        super(effect);
        this.filter = effect.filter;
        this.anyPlayer = effect.anyPlayer;
    }

    @Override
    public boolean apply(Game game, Ability source) {
        return true;
    }

    @Override
    public CastAsThoughItHadFlashAllEffect copy() {
        return new CastAsThoughItHadFlashAllEffect(this);
    }

    @Override
    public boolean applies(UUID objectId, Ability affectedAbility, Ability source, Game game, UUID playerId) {
        Card card;
        if (affectedAbility instanceof SpellAbility && (this.anyPlayer || source.isControlledBy(playerId)) && (card = ((SpellAbility)affectedAbility).getCharacteristics(game)) != null) {
            return this.filter.match(card, playerId, source, game);
        }
        return false;
    }

    @Override
    public boolean applies(UUID objectId, Ability source, UUID affectedControllerId, Game game) {
        throw new IllegalArgumentException("Wrong code usage: can't call applies method on empty affectedAbility");
    }

    private String setText() {
        StringBuilder sb = new StringBuilder(this.anyPlayer ? "any player" : "you");
        sb.append(" may cast ");
        sb.append(this.filter.getMessage());
        if (!this.duration.toString().isEmpty()) {
            if (this.duration == Duration.EndOfTurn) {
                sb.append(" this turn");
            } else {
                sb.append(' ');
                sb.append(this.duration.toString());
            }
        }
        return sb.append(" as though they had flash").toString();
    }
}

