/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.continuous;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.keyword.ReplicateAbility;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.filter.FilterSpell;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.stack.Spell;
import mage.game.stack.StackObject;

public class EachSpellYouCastHasReplicateEffect
extends ContinuousEffectImpl {
    private final FilterSpell filter;
    private final Cost fixedNewCost;
    private final Map<UUID, ReplicateAbility> replicateAbilities = new HashMap<UUID, ReplicateAbility>();

    public EachSpellYouCastHasReplicateEffect(FilterSpell filter, String reminderText) {
        this(filter, reminderText, null);
    }

    public EachSpellYouCastHasReplicateEffect(FilterSpell filter, String reminderText, Cost fixedNewCost) {
        super(Duration.WhileOnBattlefield, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.AddAbility);
        this.filter = filter;
        this.fixedNewCost = fixedNewCost;
        this.staticText = "Each " + this.filter.getMessage() + (this.filter.getMessage().contains("cast") ? "" : " you cast") + " has replicate" + (this.fixedNewCost == null ? ". The replicate cost is equal to its mana cost" : ' ' + this.fixedNewCost.getText()) + (reminderText != null && !reminderText.isEmpty() ? ". <i>(" + reminderText + ")</i>" : "");
    }

    private EachSpellYouCastHasReplicateEffect(EachSpellYouCastHasReplicateEffect effect) {
        super(effect);
        this.filter = effect.filter;
        this.fixedNewCost = effect.fixedNewCost;
        this.replicateAbilities.putAll(effect.replicateAbilities);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (permanent == null || !permanent.isControlledBy(source.getControllerId())) {
            return false;
        }
        boolean applied = false;
        for (StackObject stackObject : game.getStack()) {
            if (!(stackObject instanceof Spell) || stackObject.isCopy() || !stackObject.isControlledBy(source.getControllerId()) || this.fixedNewCost == null && stackObject.getManaCost().isEmpty()) continue;
            Spell spell = (Spell)stackObject;
            if (!this.filter.match(stackObject, game)) continue;
            Cost cost = this.fixedNewCost != null ? this.fixedNewCost.copy() : spell.getSpellAbility().getManaCosts().copy();
            ReplicateAbility replicateAbility = this.replicateAbilities.computeIfAbsent(spell.getId(), k -> new ReplicateAbility(cost));
            game.getState().addOtherAbility(spell.getCard(), replicateAbility, false);
            applied = true;
        }
        if (game.getStack().isEmpty()) {
            this.replicateAbilities.clear();
        }
        return applied;
    }

    @Override
    public EachSpellYouCastHasReplicateEffect copy() {
        return new EachSpellYouCastHasReplicateEffect(this);
    }
}

