/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.continuous;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.Target;

public class ExchangeControlTargetEffect
extends ContinuousEffectImpl {
    private String rule;
    private boolean withSource;
    private boolean withSecondTarget;
    private boolean destroyAttachedAuras;
    private Map<UUID, Integer> zoneChangeCounter = new HashMap<UUID, Integer>();
    private Map<UUID, UUID> lockedControllers = new HashMap<UUID, UUID>();

    public ExchangeControlTargetEffect(Duration duration, String rule) {
        this(duration, rule, false);
    }

    public ExchangeControlTargetEffect(Duration duration, String rule, boolean withSource) {
        this(duration, rule, withSource, false);
    }

    public ExchangeControlTargetEffect(Duration duration, String rule, boolean withSource, boolean withSecondTarget) {
        this(duration, rule, withSource, withSecondTarget, false);
    }

    public ExchangeControlTargetEffect(Duration duration, String rule, boolean withSource, boolean withSecondTarget, boolean destroyAttachedAuras) {
        super(duration, Layer.ControlChangingEffects_2, SubLayer.NA, Outcome.GainControl);
        this.withSource = withSource;
        this.withSecondTarget = withSecondTarget;
        this.destroyAttachedAuras = destroyAttachedAuras;
        this.rule = rule;
    }

    protected ExchangeControlTargetEffect(ExchangeControlTargetEffect effect) {
        super(effect);
        this.rule = effect.rule;
        this.withSource = effect.withSource;
        this.withSecondTarget = effect.withSecondTarget;
        this.destroyAttachedAuras = effect.destroyAttachedAuras;
        this.lockedControllers = new HashMap<UUID, UUID>(effect.lockedControllers);
        this.zoneChangeCounter = new HashMap<UUID, Integer>(effect.zoneChangeCounter);
    }

    @Override
    public ExchangeControlTargetEffect copy() {
        return new ExchangeControlTargetEffect(this);
    }

    @Override
    public boolean isInactive(Ability source, Game game) {
        return this.isDiscarded();
    }

    @Override
    public void init(Ability source, Game game) {
        super.init(source, game);
        Permanent permanent1 = null;
        Permanent permanent2 = null;
        if (this.withSource) {
            permanent1 = game.getPermanent(this.getTargetPointer().getFirst(game, source));
            permanent2 = game.getPermanent(source.getSourceId());
        } else {
            UUID uuid;
            for (UUID permanentId : this.getTargetPointer().getTargets(game, source)) {
                if (permanent1 == null) {
                    permanent1 = game.getPermanent(permanentId);
                    continue;
                }
                if (permanent2 != null) continue;
                permanent2 = game.getPermanent(permanentId);
            }
            if (this.withSecondTarget) {
                uuid = ((Target)source.getTargets().get(1)).getFirstTarget();
                permanent2 = game.getPermanent(uuid);
            } else if (permanent2 == null) {
                uuid = ((Target)source.getTargets().get(0)).getFirstTarget();
                permanent2 = game.getPermanent(uuid);
            }
        }
        if (permanent1 != null && permanent2 != null) {
            if (permanent1.isControlledBy(permanent2.getControllerId())) {
                this.discard();
                return;
            }
            this.lockedControllers.put(permanent1.getId(), permanent2.getControllerId());
            this.lockedControllers.put(permanent2.getId(), permanent1.getControllerId());
            this.zoneChangeCounter.put(permanent1.getId(), permanent1.getZoneChangeCounter(game));
            this.zoneChangeCounter.put(permanent2.getId(), permanent2.getZoneChangeCounter(game));
        } else {
            this.discard();
        }
    }

    @Override
    public boolean apply(Game game, Ability source) {
        HashSet<UUID> toDelete = new HashSet<UUID>();
        for (Map.Entry<UUID, Integer> entry : this.zoneChangeCounter.entrySet()) {
            Permanent permanent = game.getPermanent(entry.getKey());
            if (permanent == null || permanent.getZoneChangeCounter(game) != entry.getValue().intValue()) {
                toDelete.add(entry.getKey());
                continue;
            }
            permanent.changeControllerId(this.lockedControllers.get(permanent.getId()), game, source);
            permanent.getAbilities().setControllerId(this.lockedControllers.get(permanent.getId()));
            if (!this.destroyAttachedAuras) continue;
            FilterPermanent filter = new FilterPermanent();
            filter.add(SubType.AURA.getPredicate());
            for (UUID attachmentId : new HashSet<UUID>(permanent.getAttachments())) {
                Permanent attachment = game.getPermanent(attachmentId);
                if (!filter.match(attachment, game)) continue;
                attachment.destroy(source, game, false);
            }
        }
        if (!toDelete.isEmpty()) {
            for (UUID uuid : toDelete) {
                this.zoneChangeCounter.remove(uuid);
                this.lockedControllers.remove(uuid);
            }
            if (this.zoneChangeCounter.isEmpty()) {
                this.discard();
                return false;
            }
        }
        return true;
    }

    @Override
    public String getText(Mode mode) {
        return this.rule;
    }
}

