/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.continuous;

import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

public class GainAbilitySourceEffect
extends ContinuousEffectImpl {
    protected Ability ability;
    private final boolean onCard;

    public GainAbilitySourceEffect(Ability ability) {
        this(ability, Duration.WhileOnBattlefield);
    }

    public GainAbilitySourceEffect(Ability ability, Duration duration) {
        this(ability, duration, false);
    }

    public GainAbilitySourceEffect(Ability ability, Duration duration, boolean onCard) {
        super(duration, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.AddAbility);
        this.ability = ability;
        this.onCard = onCard;
        this.staticText = "{this} " + (duration == Duration.WhileOnBattlefield ? "has" : "gains") + ' ' + CardUtil.stripReminderText(ability.getRule()) + (duration.toString().isEmpty() ? "" : ' ' + duration.toString());
        this.generateGainAbilityDependencies(ability, null);
    }

    protected GainAbilitySourceEffect(GainAbilitySourceEffect effect) {
        super(effect);
        this.ability = effect.ability.copy();
        this.ability.newId();
        this.onCard = effect.onCard;
    }

    @Override
    public GainAbilitySourceEffect copy() {
        return new GainAbilitySourceEffect(this);
    }

    @Override
    public void init(Ability source, Game game) {
        super.init(source, game);
        if (!this.onCard && Duration.WhileOnBattlefield != this.duration && source.getSourcePermanentIfItStillExists(game) == null) {
            this.discard();
            return;
        }
        if (this.getAffectedObjectsSet()) {
            Permanent permanent = game.getPermanentEntering(source.getSourceId());
            if (permanent != null) {
                this.affectedObjectList.add(new MageObjectReference(source.getSourceId(), game.getState().getZoneChangeCounter(source.getSourceId()) + 1, game));
            } else {
                this.affectedObjectList.add(new MageObjectReference(source.getSourceId(), game));
            }
        }
    }

    @Override
    public boolean apply(Game game, Ability source) {
        if (this.onCard) {
            Card card = this.getAffectedObjectsSet() ? ((MageObjectReference)this.affectedObjectList.get(0)).getCard(game) : game.getCard(source.getSourceId());
            if (card != null) {
                game.getState().addOtherAbility(card, this.ability);
                return true;
            }
        } else {
            Permanent permanent = this.getAffectedObjectsSet() ? ((MageObjectReference)this.affectedObjectList.get(0)).getPermanent(game) : game.getPermanent(source.getSourceId());
            if (permanent != null) {
                permanent.addAbility(this.ability, source.getSourceId(), game);
                return true;
            }
        }
        if (this.duration == Duration.Custom) {
            this.discard();
        }
        return true;
    }
}

