/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.continuous;

import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.common.continuous.GainAbilitySourceEffect;
import mage.abilities.keyword.ProtectionAbility;
import mage.choices.ChoiceColor;
import mage.constants.Duration;
import mage.filter.FilterCard;
import mage.filter.predicate.mageobject.ColorPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

public class GainProtectionFromColorSourceEffect
extends GainAbilitySourceEffect {
    FilterCard protectionFilter;

    public GainProtectionFromColorSourceEffect(Duration duration) {
        super(new ProtectionAbility(new FilterCard()), duration);
        this.protectionFilter = (FilterCard)((ProtectionAbility)this.ability).getFilter();
    }

    protected GainProtectionFromColorSourceEffect(GainProtectionFromColorSourceEffect effect) {
        super(effect);
        this.protectionFilter = effect.protectionFilter.copy();
    }

    @Override
    public GainProtectionFromColorSourceEffect copy() {
        return new GainProtectionFromColorSourceEffect(this);
    }

    @Override
    public void init(Ability source, Game game) {
        super.init(source, game);
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            ChoiceColor colorChoice = new ChoiceColor(true);
            colorChoice.setMessage("Choose color for protection ability");
            if (controller.choose(this.outcome, colorChoice, game)) {
                game.informPlayers("Chosen color: " + colorChoice.getColor());
                this.protectionFilter.add(new ColorPredicate(colorChoice.getColor()));
                this.protectionFilter.setMessage(colorChoice.getChoice());
                ((ProtectionAbility)this.ability).setFilter(this.protectionFilter);
                return;
            }
        }
        this.discard();
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (permanent != null && new MageObjectReference(permanent, game).refersTo(source.getSourceObject(game), game)) {
            permanent.addAbility(this.ability, source.getSourceId(), game);
        } else {
            this.discard();
        }
        return true;
    }

    @Override
    public String getText(Mode mode) {
        return "{this} gains protection from the color of your choice " + this.duration.toString();
    }
}

