/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.continuous;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.AttachmentType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.game.permanent.Permanent;

public class LoseAllAbilitiesAttachedEffect
extends ContinuousEffectImpl {
    protected AttachmentType attachmentType;

    public LoseAllAbilitiesAttachedEffect(AttachmentType attachmentType) {
        super(Duration.WhileOnBattlefield, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.LoseAbility);
        this.attachmentType = attachmentType;
        this.setText();
    }

    protected LoseAllAbilitiesAttachedEffect(LoseAllAbilitiesAttachedEffect effect) {
        super(effect);
        this.attachmentType = effect.attachmentType;
    }

    @Override
    public LoseAllAbilitiesAttachedEffect copy() {
        return new LoseAllAbilitiesAttachedEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Permanent creature;
        Permanent equipment = game.getPermanent(source.getSourceId());
        if (equipment != null && equipment.getAttachedTo() != null && (creature = game.getPermanent(equipment.getAttachedTo())) != null) {
            creature.removeAllAbilities(source.getSourceId(), game);
            return true;
        }
        return false;
    }

    private void setText() {
        this.staticText = this.attachmentType.verb() + " creature loses all abilities";
    }
}

