/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.continuous;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.game.permanent.Permanent;

public class LoseAllAbilitiesTargetEffect
extends ContinuousEffectImpl {
    public LoseAllAbilitiesTargetEffect(Duration duration) {
        super(duration, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.AddAbility);
    }

    protected LoseAllAbilitiesTargetEffect(LoseAllAbilitiesTargetEffect effect) {
        super(effect);
    }

    @Override
    public LoseAllAbilitiesTargetEffect copy() {
        return new LoseAllAbilitiesTargetEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        int affectedTargets = 0;
        for (UUID permanentId : this.getTargetPointer().getTargets(game, source)) {
            Permanent permanent = game.getPermanent(permanentId);
            if (permanent == null) continue;
            permanent.removeAllAbilities(source.getSourceId(), game);
            ++affectedTargets;
        }
        return affectedTargets > 0;
    }

    @Override
    public String getText(Mode mode) {
        if (this.staticText != null && !this.staticText.isEmpty()) {
            return this.staticText;
        }
        return this.getTargetPointer().describeTargets(mode.getTargets(), "it") + " loses all abilities" + (this.duration.toString().isEmpty() ? "" : ' ' + this.duration.toString());
    }
}

